/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.orecruncher.dsurround.lib.GameUtils;

public final class WorldContext {
    public final Minecraft mc;
    public final Player player;
    public final Level world;
    public final Vec3 playerPosition;
    public final Vec3 playerEyePosition;
    public final BlockPos playerPos;
    public final BlockPos playerEyePos;
    public final boolean isPrecipitating;
    public final float precipitationStrength;
    public final float auralDampening;

    public WorldContext() {
        if (GameUtils.isInGame()) {
            this.world = (Level)GameUtils.getWorld().orElseThrow();
            this.player = GameUtils.getPlayer().orElseThrow();
            this.isPrecipitating = this.world.isRaining();
            this.playerPosition = this.player.getPosition(1.0f);
            this.playerEyePosition = this.player.getEyePosition();
            this.playerPos = BlockPos.containing((Position)this.playerPosition);
            this.playerEyePos = BlockPos.containing((Position)this.playerEyePosition);
            this.auralDampening = this.player.isUnderWater() ? 0.6f : 0.0f;
            this.precipitationStrength = this.world.getRainLevel(1.0f);
            this.mc = GameUtils.getMC();
        } else {
            this.mc = null;
            this.player = null;
            this.world = null;
            this.isPrecipitating = false;
            this.playerPosition = Vec3.ZERO;
            this.playerEyePosition = Vec3.ZERO;
            this.playerPos = BlockPos.ZERO;
            this.playerEyePos = BlockPos.ZERO;
            this.auralDampening = 0.0f;
            this.precipitationStrength = 0.0f;
        }
    }

    public boolean isNotValid() {
        return this.mc == null;
    }
}

