/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.sets.impl;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import org.orecruncher.dsurround.config.BiomeTrait;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Lazy;
import org.orecruncher.dsurround.lib.scripting.IVariableAccess;
import org.orecruncher.dsurround.lib.scripting.VariableSet;
import org.orecruncher.dsurround.mixinutils.IBiomeExtended;
import org.orecruncher.dsurround.runtime.sets.IBiomeVariables;

public class BiomeVariables
extends VariableSet<IBiomeVariables>
implements IBiomeVariables {
    private final IBiomeLibrary biomeLibrary;
    private final Lazy<String> precipitationType = new Lazy<String>(() -> {
        BlockPos pos = GameUtils.getPlayer().orElseThrow().blockPosition();
        return this.biome.getPrecipitationAt(pos).name();
    });
    private final Lazy<String> id = new Lazy<String>(() -> this.info.getBiomeId().toString());
    private Biome biome;
    private BiomeInfo info;

    public BiomeVariables(IBiomeLibrary biomeLibrary) {
        super("biome");
        this.biomeLibrary = biomeLibrary;
    }

    @Override
    public IBiomeVariables getInterface() {
        return this;
    }

    @Override
    public void update(IVariableAccess variableAccess) {
        Biome newBiome = null;
        if (GameUtils.isInGame()) {
            Player player = GameUtils.getPlayer().orElseThrow();
            newBiome = (Biome)player.level().getBiome(player.getOnPos()).value();
        }
        this.setBiome(newBiome, variableAccess);
    }

    public void setBiome(Biome biome, IVariableAccess variableAccess) {
        if (biome != null) {
            BiomeInfo info = this.biomeLibrary.getBiomeInfo(biome);
            this.setBiome(biome, info, variableAccess);
        } else {
            this.setBiome(null, null, variableAccess);
        }
    }

    public void setBiome(Biome biome, BiomeInfo info, IVariableAccess variableAccess) {
        this.biome = biome;
        this.info = info;
        this.id.reset();
        this.precipitationType.reset();
        for (BiomeTrait trait2 : BiomeTrait.values()) {
            variableAccess.put(trait2.getName(), false);
        }
        if (this.info != null) {
            this.info.getTraits().forEach(trait -> variableAccess.put(trait.getName(), true));
        }
    }

    @Override
    public String getModId() {
        return this.info.getBiomeId().getNamespace();
    }

    @Override
    public String getId() {
        return (String)this.id.get();
    }

    @Override
    public String getName() {
        return this.info.getBiomeName();
    }

    @Override
    public float getRainfall() {
        return ((IBiomeExtended)this.biome).dsurround_getWeather().downfall();
    }

    @Override
    public float getTemperature() {
        return this.biome.getBaseTemperature();
    }

    @Override
    public String getPrecipitationType() {
        return (String)this.precipitationType.get();
    }

    @Override
    public String getTraits() {
        return this.info.getTraits().toString();
    }

    @Override
    public boolean is(String trait) {
        return this.info.hasTrait(trait);
    }

    @Override
    public boolean isAllOf(String ... trait) {
        if (trait == null) {
            return false;
        }
        for (String t : trait) {
            if (this.is(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOneOf(String ... trait) {
        if (trait == null) {
            return false;
        }
        for (String t : trait) {
            if (!this.is(t)) continue;
            return true;
        }
        return false;
    }
}

