/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.sets.impl;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.scripting.IVariableAccess;
import org.orecruncher.dsurround.lib.scripting.VariableSet;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.runtime.sets.IPlayerVariables;

public class PlayerVariables
extends VariableSet<IPlayerVariables>
implements IPlayerVariables {
    private boolean isSuffocating;
    private boolean canSeeSky;
    private boolean canRainOn;
    private boolean isCreative;
    private boolean isBurning;
    private boolean isFlying;
    private boolean isSprinting;
    private boolean isInLava;
    private boolean isInvisible;
    private boolean isInWater;
    private boolean isWet;
    private boolean isRiding;
    private boolean isOnGround;
    private boolean isMoving;
    private float health;
    private float maxHealth;
    private float foodLevel;
    private float foodSaturationLevel;
    private double x;
    private double y;
    private double z;

    public PlayerVariables() {
        super("player");
    }

    @Override
    public void update(IVariableAccess variableAccess) {
        if (GameUtils.isInGame()) {
            Player player = GameUtils.getPlayer().orElseThrow();
            FoodData hm = player.getFoodData();
            Level world = player.level();
            this.isCreative = player.isCreative();
            this.isBurning = player.isOnFire();
            this.isFlying = player.getAbilities().flying;
            this.isSprinting = player.isSprinting();
            this.isInLava = player.isInLava();
            this.isInvisible = player.isInvisible();
            this.isInWater = player.isUnderWater();
            this.isWet = player.isInWaterOrRain();
            this.isRiding = player.isPassenger();
            this.isOnGround = player.onGround();
            this.isMoving = player.bob != player.oBob;
            this.health = player.getHealth();
            this.maxHealth = player.getMaxHealth();
            this.foodLevel = hm.getFoodLevel();
            this.foodSaturationLevel = hm.getSaturationLevel();
            this.x = player.getX();
            this.y = player.getY();
            this.z = player.getZ();
            this.isSuffocating = !player.isCreative() && player.getAirSupply() < 0;
            this.canRainOn = world.canSeeSky(player.blockPosition().offset(0, 2, 0));
            this.canSeeSky = this.canRainOn && WorldUtils.getTopSolidOrLiquidBlock(world, player.blockPosition()).getY() <= player.blockPosition().getY();
        } else {
            this.isCreative = false;
            this.isBurning = false;
            this.isFlying = false;
            this.isSprinting = false;
            this.isInLava = false;
            this.isInvisible = false;
            this.isInWater = false;
            this.isWet = false;
            this.isRiding = false;
            this.isOnGround = false;
            this.health = 20.0f;
            this.maxHealth = 20.0f;
            this.foodLevel = 20.0f;
            this.foodSaturationLevel = 20.0f;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            this.isSuffocating = false;
            this.canRainOn = false;
            this.canSeeSky = false;
        }
    }

    @Override
    public IPlayerVariables getInterface() {
        return this;
    }

    @Override
    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public boolean isBurning() {
        return this.isBurning;
    }

    @Override
    public boolean isSuffocating() {
        return this.isSuffocating;
    }

    @Override
    public boolean isFlying() {
        return this.isFlying;
    }

    @Override
    public boolean isSprinting() {
        return this.isSprinting;
    }

    @Override
    public boolean isInLava() {
        return this.isInLava;
    }

    @Override
    public boolean isInvisible() {
        return this.isInvisible;
    }

    @Override
    public boolean isInWater() {
        return this.isInWater;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }

    @Override
    public boolean isWet() {
        return this.isWet;
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Override
    public boolean canRainOn() {
        return this.canRainOn;
    }

    @Override
    public boolean canSeeSky() {
        return this.canSeeSky;
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public float getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public float getFoodLevel() {
        return this.foodLevel;
    }

    @Override
    public float getFoodSaturationLevel() {
        return this.foodSaturationLevel;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public boolean hasEffect(String effect) {
        try {
            ResourceLocation id = ResourceLocation.parse((String)effect);
            Holder.Reference r = RegistryUtils.getRegistryEntry(Registries.MOB_EFFECT, id).orElseThrow();
            return GameUtils.getPlayer().map(p -> p.hasEffect((Holder)r)).orElse(false);
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

