/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.runtime.audio.AudioUtilities;
import org.orecruncher.dsurround.sound.AudioPlayer;

public class AudioPlayerDebug
extends AudioPlayer {
    private final IModLog logger;

    public AudioPlayerDebug(SoundManager manager, IModLog logger) {
        super(manager);
        this.logger = ModLog.createChild(logger, "AudioPlayer");
    }

    @Override
    public void play(SoundInstance sound) {
        this.logger.debug(1, () -> String.format("PLAYING %s", this.formatSound(sound)));
        super.play(sound);
    }

    @Override
    public void stop(SoundInstance sound) {
        this.logger.debug(1, () -> String.format("STOPPING %s", this.formatSound(sound)));
        super.stop(sound);
    }

    @Override
    public void stopAll() {
        this.logger.debug(1, "STOPPING all sounds", new Object[0]);
        super.stopAll();
    }

    protected String formatSound(SoundInstance sound) {
        return AudioUtilities.debugString(sound);
    }
}

