/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import com.google.common.base.MoreObjects;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.sound.SoundVolumeEvaluator;

public class BackgroundSoundLoop
extends AbstractTickableSoundInstance {
    private static final float INITIAL_SCALE = 2.0E-5f;
    private static final float SCALE_AMOUNT = 0.033f;
    private float scale = 2.0E-5f;
    private float target = 1.0f;
    private boolean isFading = false;

    public BackgroundSoundLoop(SoundEvent soundEvent) {
        super(soundEvent, SoundSource.AMBIENT, (RandomSource)Randomizer.current());
        this.looping = true;
        this.delay = 0;
        this.attenuation = SoundInstance.Attenuation.NONE;
        this.relative = true;
    }

    public BackgroundSoundLoop(SoundEvent soundEvent, BlockPos pos) {
        super(soundEvent, SoundSource.AMBIENT, (RandomSource)Randomizer.current());
        this.looping = true;
        this.delay = 0;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.relative = false;
        this.x = (float)pos.getX() + 0.5f;
        this.y = (float)pos.getY() + 0.5f;
        this.z = (float)pos.getZ() + 0.5f;
    }

    public void tick() {
        if (this.scale < this.target && !this.isFading) {
            this.scale += 0.033f;
        } else if (this.isFading || this.scale > this.target) {
            this.scale -= 0.033f;
        }
        this.scale = Mth.clamp((float)this.scale, (float)0.0f, (float)this.target);
        if (Float.compare(this.getVolume(), 0.0f) == 0) {
            this.stop();
        }
    }

    public BlockPos getPos() {
        return BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
    }

    public BackgroundSoundLoop setVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public BackgroundSoundLoop setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public float getVolume() {
        return this.sound == null ? 0.0f : super.getVolume() * this.scale;
    }

    public void setScaleTarget(float target) {
        this.target = target;
    }

    public boolean isFading() {
        return this.isFading;
    }

    public void fadeOut() {
        this.isFading = true;
    }

    public void fadeIn() {
        this.isFading = false;
    }

    @NotNull
    public String toString() {
        MoreObjects.ToStringHelper temp = MoreObjects.toStringHelper((Object)((Object)this)).addValue((Object)this.getLocation().toString()).addValue((Object)this.getSource().getName());
        if (this.sound != null) {
            temp.add("v", this.getVolume()).add("ev", SoundVolumeEvaluator.getAdjustedVolume((SoundInstance)this)).add("p", this.getPitch());
        }
        return temp.add("f", this.scale).add("fading", this.isFading()).toString();
    }
}

