/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.orecruncher.dsurround.lib.math.MathStuff;
import org.orecruncher.dsurround.sound.BackgroundSoundLoop;

public interface ISoundFactory {
    public ResourceLocation getLocation();

    public EntityBoundSoundInstance attachToEntity(Entity var1);

    public BackgroundSoundLoop createBackgroundSoundLoop();

    public BackgroundSoundLoop createBackgroundSoundLoopAt(BlockPos var1);

    default public SimpleSoundInstance createAsMood(Entity entity, int minRange, int maxRange) {
        Vec3 offset = MathStuff.randomPoint(minRange, maxRange);
        Vec3 position = entity.getEyePosition().add(offset);
        return this.createAtLocation(position, 1.0f);
    }

    public SimpleSoundInstance createAsAdditional();

    default public SimpleSoundInstance createAtLocation(BlockPos pos) {
        return this.createAtLocation(Vec3.atCenterOf((Vec3i)pos), 1.0f);
    }

    default public SimpleSoundInstance createAtLocation(BlockPos pos, float volumeScale) {
        return this.createAtLocation(Vec3.atCenterOf((Vec3i)pos), volumeScale);
    }

    default public SimpleSoundInstance createAtLocation(Entity entity) {
        return this.createAtLocation(entity.getEyePosition(), 1.0f);
    }

    default public SimpleSoundInstance createAtLocation(Vec3 position) {
        return this.createAtLocation(position, 1.0f);
    }

    default public SimpleSoundInstance createAtLocation(Vec3 position, float volumeScale) {
        return this.createAtLocation(position.x(), position.y(), position.z(), volumeScale);
    }

    public SimpleSoundInstance createAtLocation(double var1, double var3, double var5, float var7);

    public Music createAsMusic();
}

