/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import org.orecruncher.dsurround.lib.IdentityUtils;

public class SoundCodecHelpers {
    public static final Codec<SoundSource> SOUND_CATEGORY_CODEC = Codec.STRING.xmap(SoundCodecHelpers::lookupSoundSource, SoundSource::getName);
    public static final Codec<SoundInstance.Attenuation> ATTENUATION_CODEC = Codec.STRING.xmap(SoundCodecHelpers::lookupAttenuation, Enum::name);
    public static final Codec<SoundEvent> SOUND_EVENT_CODEC = Codec.either(IdentityUtils.CODEC, (Codec)SoundEvent.DIRECT_CODEC).xmap(either -> (SoundEvent)either.map(SoundEvent::createVariableRangeEvent, x -> x), Either::right);
    public static final Codec<FloatProvider> SOUND_PROPERTY_RANGE = Codec.either((Codec)Codec.FLOAT, RangeProperty.CODEC).xmap(either -> (FloatProvider)either.map(ConstantFloat::of, rangeProperty -> UniformFloat.of((float)rangeProperty.min, (float)rangeProperty.max)), floatProvider -> {
        throw new RuntimeException("Not gonna happen");
    });

    private static SoundSource lookupSoundSource(String string) {
        for (SoundSource c : SoundSource.values()) {
            if (!c.getName().equalsIgnoreCase(string)) continue;
            return c;
        }
        return SoundSource.AMBIENT;
    }

    private static SoundInstance.Attenuation lookupAttenuation(String string) {
        for (SoundInstance.Attenuation c : SoundInstance.Attenuation.values()) {
            if (!c.name().equalsIgnoreCase(string)) continue;
            return c;
        }
        return SoundInstance.Attenuation.LINEAR;
    }

    public record RangeProperty(float min, float max) {
        static Codec<RangeProperty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("min", (Object)Float.valueOf(1.0f)).forGetter(RangeProperty::min), (App)Codec.FLOAT.optionalFieldOf("max", (Object)Float.valueOf(1.0f)).forGetter(RangeProperty::max)).apply((Applicative)instance, RangeProperty::new));
    }
}

