/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.lib.IdentityUtils;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.sound.BackgroundSoundLoop;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundCodecHelpers;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;

public record SoundFactory(Optional<ResourceLocation> location, SoundEvent soundEvent, FloatProvider volume, FloatProvider pitch, SoundSource category, boolean isRepeatable, int repeatDelay, boolean global, SoundInstance.Attenuation attenuation, MusicSettings musicSettings) implements Comparable<ISoundFactory>,
ISoundFactory
{
    public static final Codec<SoundFactory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IdentityUtils.CODEC.optionalFieldOf("location").forGetter(SoundFactory::location), (App)SoundCodecHelpers.SOUND_EVENT_CODEC.fieldOf("soundEvent").forGetter(SoundFactory::soundEvent), (App)SoundCodecHelpers.SOUND_PROPERTY_RANGE.optionalFieldOf("volume", (Object)ConstantFloat.of((float)1.0f)).forGetter(SoundFactory::volume), (App)SoundCodecHelpers.SOUND_PROPERTY_RANGE.optionalFieldOf("pitch", (Object)ConstantFloat.of((float)1.0f)).forGetter(SoundFactory::pitch), (App)SoundCodecHelpers.SOUND_CATEGORY_CODEC.optionalFieldOf("category", (Object)SoundSource.AMBIENT).forGetter(SoundFactory::category), (App)Codec.BOOL.optionalFieldOf("isRepeatable", (Object)false).forGetter(SoundFactory::isRepeatable), (App)Codec.INT.optionalFieldOf("repeatDelay", (Object)0).forGetter(SoundFactory::repeatDelay), (App)Codec.BOOL.optionalFieldOf("global", (Object)false).forGetter(SoundFactory::global), (App)SoundCodecHelpers.ATTENUATION_CODEC.optionalFieldOf("attenuation", (Object)SoundInstance.Attenuation.LINEAR).forGetter(SoundFactory::attenuation), (App)MusicSettings.CODEC.optionalFieldOf("music", (Object)MusicSettings.DEFAULT).forGetter(SoundFactory::musicSettings)).apply((Applicative)instance, SoundFactory::new));
    private static final Map<SoundEvent, Music> MUSIC_MAP = new HashMap<SoundEvent, Music>();

    @Override
    public ResourceLocation getLocation() {
        return this.location.orElse(this.soundEvent.getLocation());
    }

    @Override
    public BackgroundSoundLoop createBackgroundSoundLoop() {
        return new BackgroundSoundLoop(this.soundEvent).setVolume(this.getVolume()).setPitch(this.getPitch());
    }

    @Override
    public BackgroundSoundLoop createBackgroundSoundLoopAt(BlockPos pos) {
        return new BackgroundSoundLoop(this.soundEvent, pos).setVolume(this.getVolume()).setPitch(this.getPitch());
    }

    @Override
    public SimpleSoundInstance createAsAdditional() {
        return new SimpleSoundInstance(this.soundEvent.getLocation(), this.category, this.getVolume(), this.getPitch(), (RandomSource)Randomizer.current(), this.isRepeatable, this.repeatDelay, this.attenuation, 0.0, 0.0, 0.0, true);
    }

    @Override
    public EntityBoundSoundInstance attachToEntity(Entity entity) {
        return new EntityBoundSoundInstance(this.soundEvent, this.category, this.getVolume(), this.getPitch(), entity, Randomizer.current().nextLong());
    }

    @Override
    public SimpleSoundInstance createAtLocation(double posX, double posY, double posZ, float volumeScale) {
        return new SimpleSoundInstance(this.soundEvent.getLocation(), this.category, this.getVolume() * volumeScale, this.getPitch(), (RandomSource)Randomizer.current(), this.isRepeatable, this.repeatDelay, this.attenuation, posX, posY, posZ, this.global);
    }

    @Override
    public Music createAsMusic() {
        return MUSIC_MAP.computeIfAbsent(this.soundEvent, key -> {
            Holder holder = Holder.direct((Object)key);
            return new Music(holder, this.musicSettings.minDelay, this.musicSettings.maxDelay, this.musicSettings.replaceCurrentMusic);
        });
    }

    private float getVolume() {
        return this.volume.sample((RandomSource)Randomizer.current());
    }

    private float getPitch() {
        return this.pitch.sample((RandomSource)Randomizer.current());
    }

    @Override
    public int hashCode() {
        return this.getLocation().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SoundFactory)) return false;
        SoundFactory f = (SoundFactory)obj;
        if (!this.getLocation().equals((Object)f.getLocation())) return false;
        return true;
    }

    @Override
    public int compareTo(@NotNull ISoundFactory o) {
        return this.getLocation().compareTo(o.getLocation());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.getLocation()).add("soundEvent", (Object)this.soundEvent.getLocation()).toString();
    }

    static ISoundFactory from(SoundFactoryBuilder builder) {
        return new SoundFactory(Optional.empty(), builder.soundEvent, builder.volume, builder.pitch, builder.category, builder.isRepeatable, builder.repeatDelay, builder.global, builder.attenuation, new MusicSettings(builder.musicMinDelay, builder.musicMaxDelay, builder.musicReplaceMusic));
    }

    public record MusicSettings(int minDelay, int maxDelay, boolean replaceCurrentMusic) {
        public static final MusicSettings DEFAULT = new MusicSettings(6000, 24000, false);
        public static final Codec<MusicSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min_delay", (Object)DEFAULT.minDelay()).forGetter(MusicSettings::minDelay), (App)Codec.INT.optionalFieldOf("max_delay", (Object)DEFAULT.maxDelay()).forGetter(MusicSettings::maxDelay), (App)Codec.BOOL.optionalFieldOf("replace_current_music", (Object)DEFAULT.replaceCurrentMusic()).forGetter(MusicSettings::replaceCurrentMusic)).apply((Applicative)instance, MusicSettings::new));
    }
}

