/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import net.minecraft.client.resources.sounds.ElytraOnPlayerSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.system.ITickCount;
import org.orecruncher.dsurround.lib.threading.IClientTasking;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public final class SoundInstanceHandler {
    private static final IClientTasking CLIENT_TASKING = ContainerManager.resolve(IClientTasking.class);
    private static final ISoundLibrary SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);
    private static final IAudioPlayer AUDIO_PLAYER = ContainerManager.resolve(IAudioPlayer.class);
    private static final ITickCount TICK_COUNT = ContainerManager.resolve(ITickCount.class);
    private static final Configuration.SoundSystem SOUND_SYSTEM_CONFIG = ContainerManager.resolve(Configuration.SoundSystem.class);
    private static final Object2LongOpenHashMap<ResourceLocation> SOUND_CULL = new Object2LongOpenHashMap(32);

    private static boolean isSoundBlocked(ResourceLocation id) {
        return SOUND_LIBRARY.isBlocked(id);
    }

    private static boolean isSoundCulled(ResourceLocation id) {
        return SOUND_LIBRARY.isCulled(id);
    }

    private static boolean isSoundCulledLogical(ResourceLocation sound) {
        int cullInterval = SoundInstanceHandler.SOUND_SYSTEM_CONFIG.cullInterval;
        if (cullInterval > 0 && SoundInstanceHandler.isSoundCulled(sound)) {
            long lastOccurrence = SOUND_CULL.getLong((Object)Objects.requireNonNull(sound));
            long currentTick = TICK_COUNT.getTickCount();
            if (currentTick - lastOccurrence < (long)cullInterval) {
                return true;
            }
            SOUND_CULL.put((Object)sound, currentTick);
        }
        return false;
    }

    public static boolean shouldBlockSoundPlay(SoundInstance theSound) {
        if (theSound instanceof ConfigSoundInstance) {
            return false;
        }
        ResourceLocation id = theSound.getLocation();
        return SoundInstanceHandler.isSoundBlocked(id) || SoundInstanceHandler.isSoundCulledLogical(id);
    }

    public static boolean remapSoundPlay(SoundInstance theSound) {
        return SOUND_LIBRARY.remapSound(theSound).map(s -> {
            AUDIO_PLAYER.play((SoundInstance)s);
            return true;
        }).orElse(false);
    }

    public static boolean inRange(Vec3 listener, SoundInstance sound, int pad) {
        if (sound.isRelative() || sound.getAttenuation() == SoundInstance.Attenuation.NONE || sound.getSource() == SoundSource.WEATHER) {
            return true;
        }
        if (sound instanceof ElytraOnPlayerSoundInstance) {
            return true;
        }
        if (sound.getX() == 0.0 && sound.getY() == 0.0 && sound.getZ() == 0.0) {
            return true;
        }
        if (sound.getSound() == null) {
            try {
                CLIENT_TASKING.execute(() -> sound.resolve(GameUtils.getSoundManager()));
            }
            catch (Throwable t) {
                Library.LOGGER.error(t, "Unable to set sound on sound instance", new Object[0]);
            }
        }
        if (sound.getVolume() > 1.0f) {
            return true;
        }
        int distSq = sound.getSound().getAttenuationDistance() + pad;
        distSq *= distSq;
        return listener.distanceToSqr(sound.getX(), sound.getY(), sound.getZ()) < (double)distSq;
    }

    public static boolean inRange(Vec3 listener, SoundInstance sound) {
        return SoundInstanceHandler.inRange(listener, sound, 0);
    }
}

