/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.orecruncher.dsurround.config.data.SoundMetadataConfig;

public final class SoundMetadata {
    private final Component title;
    private final Component subTitle;
    private final List<Credit> credits;
    private final SoundSource category;
    private final boolean isDefault;

    public SoundMetadata() {
        this.title = Component.empty();
        this.subTitle = Component.empty();
        this.credits = ImmutableList.of();
        this.category = SoundSource.AMBIENT;
        this.isDefault = true;
    }

    public SoundMetadata(ResourceLocation location) {
        this.title = Component.empty();
        this.subTitle = Component.empty();
        this.credits = ImmutableList.of();
        this.isDefault = false;
        this.category = this.estimateSoundSource(location);
    }

    public SoundMetadata(ResourceLocation location, SoundMetadataConfig cfg) {
        Objects.requireNonNull(cfg);
        this.isDefault = false;
        this.title = (Component)cfg.title().map(Component::translatable).orElse(Component.empty());
        this.subTitle = (Component)cfg.subtitle().map(Component::translatable).orElse(Component.empty());
        if (cfg.credits() == null || cfg.credits().isEmpty()) {
            this.credits = ImmutableList.of();
        } else {
            ArrayList<Credit> temp = new ArrayList<Credit>(cfg.credits().size());
            for (SoundMetadataConfig.CreditEntry entry : cfg.credits()) {
                Component name = Component.nullToEmpty((String)ChatFormatting.stripFormatting((String)entry.name()));
                Component author = Component.nullToEmpty((String)ChatFormatting.stripFormatting((String)entry.author()));
                Optional<Component> webSite = entry.website().map(website -> Component.nullToEmpty((String)ChatFormatting.stripFormatting((String)website)));
                Component license = Component.nullToEmpty((String)ChatFormatting.stripFormatting((String)entry.license()));
                Credit creditEntry = new Credit(name, author, webSite, license);
                temp.add(creditEntry);
            }
            this.credits = ImmutableList.copyOf(temp);
        }
        this.category = cfg.category().orElseGet(() -> this.estimateSoundSource(location));
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    private SoundSource estimateSoundSource(ResourceLocation location) {
        String path = location.getPath();
        if (path.startsWith("music")) {
            return SoundSource.MUSIC;
        }
        if (path.startsWith("block")) {
            return SoundSource.BLOCKS;
        }
        if (path.startsWith("entity") && path.endsWith("step")) {
            return SoundSource.NEUTRAL;
        }
        if (path.startsWith("entity")) {
            return SoundSource.HOSTILE;
        }
        if (path.startsWith("weather")) {
            return SoundSource.WEATHER;
        }
        if (path.startsWith("ambient")) {
            return SoundSource.AMBIENT;
        }
        return SoundSource.AMBIENT;
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getSubTitle() {
        return this.subTitle;
    }

    public List<Credit> getCredits() {
        return this.credits;
    }

    public SoundSource getCategory() {
        return this.category;
    }

    public record Credit(Component name, Component author, Optional<Component> webSite, Component license) {
    }
}

