/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import com.google.common.base.Preconditions;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;

public final class SoundVolumeEvaluator {
    private static final ISoundLibrary SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);

    public static float getAdjustedVolume(SoundInstance sound) {
        Preconditions.checkNotNull((Object)sound);
        float volume = sound.getVolume();
        SoundSource category = sound.getSource();
        float categoryFactor = category == SoundSource.MASTER ? 1.0f : GameUtils.getGameSettings().getSoundSourceVolume(category);
        volume *= categoryFactor;
        if (!(sound instanceof ConfigSoundInstance)) {
            float volumeScale = SOUND_LIBRARY.getVolumeScale(category, sound.getLocation());
            volume *= volumeScale;
        }
        return Mth.clamp((float)volume, (float)0.0f, (float)1.0f);
    }
}

