/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import com.mrbysco.distantfriends.Constants;
import com.mrbysco.distantfriends.FriendNamesCache;
import com.mrbysco.distantfriends.entity.goal.LookedAtGoal;
import com.mrbysco.distantfriends.platform.Services;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DistantFriend
extends PathfinderMob {
    private static final EntityDataAccessor<Optional<ResolvableProfile>> RESOLVABLE_PROFILE = SynchedEntityData.defineId(DistantFriend.class, Services.PLATFORM.getResolvableProfileSerializer());
    private static final EntityDataAccessor<Boolean> DATA_IN_VIEW = SynchedEntityData.defineId(DistantFriend.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_LOOKED_AT = SynchedEntityData.defineId(DistantFriend.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final NonNullList<ItemStack> handItems = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final TargetingConditions findPlayerCondition = TargetingConditions.forNonCombat().range(16.0);

    public DistantFriend(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RESOLVABLE_PROFILE, Optional.empty());
        builder.define(DATA_IN_VIEW, (Object)false);
        builder.define(DATA_LOOKED_AT, (Object)false);
    }

    public Optional<ResolvableProfile> getProfile() {
        return (Optional)this.entityData.get(RESOLVABLE_PROFILE);
    }

    public void setProfile(ResolvableProfile profile) {
        this.entityData.set(RESOLVABLE_PROFILE, Optional.of(profile));
    }

    public boolean isLookedAt() {
        return (Boolean)this.entityData.get(DATA_LOOKED_AT);
    }

    public void setLookedAt(boolean lookedAt) {
        this.entityData.set(DATA_LOOKED_AT, (Object)lookedAt);
    }

    public boolean isInView() {
        return (Boolean)this.entityData.get(DATA_IN_VIEW);
    }

    public void setInView(boolean inView) {
        this.entityData.set(DATA_IN_VIEW, (Object)inView);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookedAtGoal(this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 128.0f, 0.75f, false));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 32.0f, 1.0, 1.33, EntitySelector.NO_SPECTATORS::test));
        this.goalSelector.addGoal(6, (Goal)new StrollWhenOutOfSight(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, (double)0.23f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public Iterable<ItemStack> getHandSlots() {
        return this.handItems;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        return switch (slotIn.getType()) {
            case EquipmentSlot.Type.HAND -> (ItemStack)this.handItems.get(slotIn.getIndex());
            case EquipmentSlot.Type.HUMANOID_ARMOR -> (ItemStack)this.armorItems.get(slotIn.getIndex());
            default -> ItemStack.EMPTY;
        };
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack stack) {
        this.verifyEquippedItem(stack);
        switch (equipmentSlot.getType()) {
            case HAND: {
                this.onEquipItem(equipmentSlot, (ItemStack)this.handItems.set(equipmentSlot.getIndex(), (Object)stack), stack);
                break;
            }
            case HUMANOID_ARMOR: {
                this.onEquipItem(equipmentSlot, (ItemStack)this.armorItems.set(equipmentSlot.getIndex(), (Object)stack), stack);
            }
        }
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public boolean isInvisibleTo(Player player) {
        if (player.hasLineOfSight((Entity)this) && this.tickCount < 100) {
            return true;
        }
        return super.isInvisibleTo(player);
    }

    public boolean hurt(DamageSource source, float amount) {
        this.discard();
        return super.hurt(source, amount);
    }

    public void aiStep() {
        if (this.tickCount > 80 && this.tickCount % 20 == 0 && !this.level().getNearbyPlayers(this.findPlayerCondition, (LivingEntity)this, this.getBoundingBox().inflate(16.0, 32.0, 16.0)).isEmpty()) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
            }
            this.discard();
        }
        super.aiStep();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("inView", this.isInView());
        tag.putBoolean("lookedAt", this.isLookedAt());
        tag.putBoolean("profileExists", ((Optional)this.entityData.get(RESOLVABLE_PROFILE)).isPresent());
        if (this.getProfile().isPresent()) {
            tag.put("profile", (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((ResolvableProfile)((Optional)this.entityData.get(RESOLVABLE_PROFILE)).get())).getOrThrow());
        }
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.setInView(compound.getBoolean("inView"));
        this.setLookedAt(compound.getBoolean("lookedAt"));
        boolean profileExists = compound.getBoolean("profileExists");
        if (profileExists) {
            this.entityData.set(RESOLVABLE_PROFILE, (Object)ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("profile")).resultOrPartial(error -> Constants.LOGGER.error("Failed to load profile from Distant Friend: {}", error)));
        } else {
            this.entityData.set(RESOLVABLE_PROFILE, Optional.empty());
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        spawnDataIn = super.finalizeSpawn(level, difficultyIn, reason, spawnDataIn);
        List<String> friends = FriendNamesCache.nameList;
        if (!friends.isEmpty()) {
            String name = friends.get(this.random.nextInt(friends.size()));
            SkullBlockEntity.fetchGameProfile((String)name).thenAccept(profile -> {
                this.setProfile(new ResolvableProfile(profile.orElse(new GameProfile(Util.NIL_UUID, name))));
                this.setCustomName((Component)Component.literal((String)name));
            });
        }
        return spawnDataIn;
    }

    public boolean isLookingAtMe(Player player) {
        Vec3 vec3 = player.getViewVector(1.0f).normalize();
        Vec3 offsetVec = new Vec3(this.getX() - player.getX(), this.getEyeY() - player.getEyeY(), this.getZ() - player.getZ());
        double d0 = offsetVec.length();
        double d1 = vec3.dot(offsetVec = offsetVec.normalize());
        return d1 > 1.0 - 0.025 / d0 && player.hasLineOfSight((Entity)this);
    }

    public static boolean checkFriendSpawn(EntityType<? extends DistantFriend> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return levelAccessor.getDifficulty() != Difficulty.PEACEFUL && DistantFriend.isDarkEnoughToSpawn(levelAccessor, pos, random) && DistantFriend.checkMobSpawnRules(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor levelAccessor, BlockPos pos, RandomSource random) {
        if (levelAccessor.getBrightness(LightLayer.SKY, pos) > random.nextInt(32)) {
            return false;
        }
        if (levelAccessor.getBrightness(LightLayer.BLOCK, pos) > 0) {
            return false;
        }
        int i = levelAccessor.getLevel().isThundering() ? levelAccessor.getMaxLocalRawBrightness(pos, 10) : levelAccessor.getMaxLocalRawBrightness(pos);
        return i <= random.nextInt(8);
    }

    static class StrollWhenOutOfSight
    extends WaterAvoidingRandomStrollGoal {
        private final DistantFriend friend;

        public StrollWhenOutOfSight(DistantFriend friend) {
            super((PathfinderMob)friend, 1.0);
            this.friend = friend;
        }

        public boolean canUse() {
            return super.canUse() && !this.friend.isInView();
        }
    }
}

