/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.entity.goal;

import com.mrbysco.distantfriends.entity.DistantFriend;
import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class LookedAtGoal
extends Goal {
    private final TargetingConditions lookTargeting = TargetingConditions.forNonCombat().range(256.0);
    @Nullable
    private Player player;
    private final DistantFriend friend;
    private final RandomSource random;
    private int crouchInterval = 10;
    private int punchInterval = 5;

    public LookedAtGoal(DistantFriend friend) {
        this.friend = friend;
        this.random = friend.getRandom();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        this.player = this.friend.level().getNearestPlayer(this.lookTargeting, (LivingEntity)this.friend);
        return this.player != null;
    }

    public boolean canContinueToUse() {
        if (this.player != null && !this.player.isAlive()) {
            return false;
        }
        return this.friend.blockPosition().distManhattan((Vec3i)this.player.blockPosition()) <= 512;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        super.start();
        this.friend.setPose(Pose.STANDING);
        this.friend.setAggressive(false);
    }

    public void stop() {
        super.stop();
        this.friend.setPose(Pose.STANDING);
        this.friend.setAggressive(false);
    }

    public void tick() {
        boolean inView = false;
        if (this.player != null) {
            boolean lookingAtMe = this.friend.isLookingAtMe(this.player);
            boolean lookedAt = this.friend.isLookedAt();
            if (lookingAtMe) {
                if (!lookedAt) {
                    this.friend.setLookedAt(true);
                    this.friend.getNavigation().stop();
                }
            } else {
                this.friend.setLookedAt(false);
            }
            if (this.player.hasLineOfSight((Entity)this.friend)) {
                inView = true;
            }
        }
        if (this.friend.isInView() != inView) {
            this.friend.setInView(inView);
        }
        if (this.friend.isLookedAt()) {
            if (this.player != null) {
                this.friend.getLookControl().setLookAt(this.player.getX(), this.player.getY(), this.player.getZ());
            }
            if (this.friend.tickCount % this.crouchInterval == 0) {
                this.crouchInterval = this.random.nextInt(50) + 10;
                Pose pose = this.friend.isCrouching() ? Pose.STANDING : Pose.CROUCHING;
                this.friend.setPose(pose);
            }
            if (this.friend.tickCount % this.punchInterval == 0) {
                this.punchInterval = this.random.nextInt(25) + 10;
                this.friend.setAggressive(!this.friend.isAggressive());
            }
        }
    }
}

