/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.client.gui;

import dev.worldgen.tectonic.client.gui.ConfigList;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.config.state.ConfigState;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ConfigScreen
extends Screen {
    private final Screen parent;
    private ConfigList list;
    final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);

    public ConfigScreen(Screen parent) {
        super(ConfigScreen.text("title"));
        this.parent = parent;
    }

    public void init() {
        ConfigState state = ConfigHandler.getState();
        this.layout.addTitleHeader(this.title, this.font);
        this.list = (ConfigList)this.layout.addToContents((LayoutElement)new ConfigList(this.minecraft, this.width, this));
        this.list.addCategory("general", this.font);
        this.list.addBoolean("mod_enabled", bool -> {
            state.general.modEnabled = bool;
        }, state.general.modEnabled, true);
        this.list.addInteger("snow_start_offset", 0.0, 256.0, value -> {
            state.general.snowStartOffset = value;
        }, state.general.snowStartOffset, 128.0);
        this.list.addCategory("global_terrain", this.font);
        this.list.addDouble("vertical_scale", 0.75, 4.0, 0.005, value -> {
            state.globalTerrain.verticalScale = value;
        }, state.globalTerrain.verticalScale, 1.125);
        this.list.addBoolean("increased_height", bool -> {
            state.globalTerrain.increasedHeight = bool;
        }, state.globalTerrain.increasedHeight, false);
        this.list.addBoolean("lava_tunnels", bool -> {
            state.globalTerrain.lavaTunnels = bool;
        }, state.globalTerrain.lavaTunnels, true);
        this.list.addCategory("continents", this.font);
        this.list.addDouble("ocean_offset", -1.0, 0.0, 0.01, value -> {
            state.continents.oceanOffset = value;
        }, state.continents.oceanOffset, -0.8);
        this.list.addDouble("continents_scale", 0.01, 1.0, 0.01, value -> {
            state.continents.continentsScale = value;
        }, state.continents.continentsScale, 0.13);
        this.list.addDouble("erosion_scale", 0.01, 1.0, 0.01, value -> {
            state.continents.erosionScale = value;
        }, state.continents.erosionScale, 0.25);
        this.list.addDouble("ridge_scale", 0.01, 2.0, 0.01, value -> {
            state.continents.ridgeScale = value;
        }, state.continents.ridgeScale, 0.25);
        this.list.addBoolean("underground_rivers", bool -> {
            state.continents.undergroundRivers = bool;
        }, state.continents.undergroundRivers, true);
        this.list.addBoolean("river_lanterns", bool -> {
            state.continents.riverLanterns = bool;
        }, state.continents.riverLanterns, true);
        this.list.addDouble("flat_terrain_skew", -1.0, 1.0, 0.01, value -> {
            state.continents.flatTerrainSkew = value;
        }, state.continents.flatTerrainSkew, 0.1);
        this.list.addBoolean("rolling_hills", bool -> {
            state.continents.rollingHills = bool;
        }, state.continents.rollingHills, true);
        this.list.addBoolean("jungle_pillars", bool -> {
            state.continents.junglePillars = bool;
        }, state.continents.junglePillars, true);
        this.list.addCategory("islands", this.font);
        this.list.addBoolean("enabled", bool -> {
            state.islands.enabled = bool;
        }, state.islands.enabled, true);
        this.list.addDouble("noise_scale", 0.01, 0.5, 0.01, value -> {
            state.islands.noiseScale = value;
        }, state.islands.noiseScale, 0.11);
        this.list.addCategory("oceans", this.font);
        this.list.addDouble("ocean_depth", -0.75, -0.05, 0.01, value -> {
            state.oceans.oceanDepth = value;
        }, state.oceans.oceanDepth, -0.22);
        this.list.addDouble("deep_ocean_depth", -0.75, -0.05, 0.01, value -> {
            state.oceans.deepOceanDepth = value;
        }, state.oceans.deepOceanDepth, -0.45);
        this.list.addInteger("monument_offset", -60.0, 0.0, value -> {
            state.oceans.monumentOffset = value;
        }, state.oceans.monumentOffset, -30.0);
        this.list.addBoolean("remove_frozen_ocean_ice", bool -> {
            state.oceans.removeFrozenOceanIce = bool;
        }, state.oceans.removeFrozenOceanIce, false);
        this.list.addCategory("biomes", this.font);
        this.list.addDouble("temperature_multiplier", 0.1, 5.0, 0.1, value -> {
            state.biomes.temperatureMultiplier = value;
        }, state.biomes.temperatureMultiplier, 1.0);
        this.list.addDouble("temperature_scale", 0.01, 1.0, 0.01, value -> {
            state.biomes.temperatureScale = value;
        }, state.biomes.temperatureScale, 0.25);
        this.list.addDouble("vegetation_multiplier", 0.1, 5.0, 0.1, value -> {
            state.biomes.vegetationMultiplier = value;
        }, state.biomes.vegetationMultiplier, 1.0);
        this.list.addDouble("vegetation_scale", 0.01, 1.0, 0.01, value -> {
            state.biomes.vegetationScale = value;
        }, state.biomes.vegetationScale, 0.25);
        LinearLayout footer = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onDone()).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.list != null) {
            this.list.updateSize(this.width, this.layout);
        }
    }

    private void onDone() {
        ConfigHandler.save();
        this.onClose();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public static Component text(String name) {
        return Component.translatable((String)("config.tectonic." + name));
    }

    public static Component option(String name) {
        return ConfigScreen.text("option." + name);
    }
}

