/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.loaders.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.config.ConfigHandler;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public record ConfigResourceCondition(String key) implements ICondition
{
    public static final MapCodec<ConfigResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(ConfigResourceCondition::key)).apply((Applicative)instance, ConfigResourceCondition::new));

    public boolean test(@NotNull ICondition.IContext context) {
        return switch (this.key) {
            case "disable_islands" -> {
                if (!ConfigHandler.getState().islands.enabled) {
                    yield true;
                }
                yield false;
            }
            case "increased_height" -> ConfigHandler.getState().globalTerrain.increasedHeight;
            case "remove_frozen_ocean_ice" -> ConfigHandler.getState().oceans.removeFrozenOceanIce;
            case "river_lanterns" -> ConfigHandler.getState().continents.riverLanterns;
            default -> false;
        };
    }

    @NotNull
    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

