/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.worldgen.densityfunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.config.ConfigHandler;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record ConfigNoise(DensityFunction.NoiseHolder noise, DensityFunction shiftX, DensityFunction shiftZ, double scale) implements DensityFunction
{
    public static MapCodec<ConfigNoise> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(df -> ""), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(ConfigNoise::noise), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_x").forGetter(ConfigNoise::shiftX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_z").forGetter(ConfigNoise::shiftZ)).apply((Applicative)instance, ConfigNoise::new));
    public static KeyDispatchDataCodec<ConfigNoise> CODEC_HOLDER = KeyDispatchDataCodec.of(DATA_CODEC);

    public ConfigNoise(String key, DensityFunction.NoiseHolder noise, DensityFunction shiftX, DensityFunction shiftZ) {
        this(noise, shiftX, shiftZ, ConfigHandler.getState().getValue(key));
    }

    public double compute(DensityFunction.FunctionContext context) {
        double x = (double)context.blockX() * this.scale + this.shiftX.compute(context);
        double z = (double)context.blockZ() * this.scale + this.shiftZ.compute(context);
        return this.noise.getValue(x, 0.0, z);
    }

    public void fillArray(double[] doubles, DensityFunction.ContextProvider contextProvider) {
        contextProvider.fillAllDirectly(doubles, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new ConfigNoise(visitor.visitNoise(this.noise), this.shiftX.mapAll(visitor), this.shiftZ.mapAll(visitor), this.scale));
    }

    public double minValue() {
        return -this.maxValue();
    }

    public double maxValue() {
        return this.noise.maxValue();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

