/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.itemblacklist.blacklist;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.pitbox46.itemblacklist.mixins.EntityAccessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;

public record Group(String name, Properties properties) implements Predicate<Player>
{
    public static Codec<Group> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Group::name), (App)Properties.CODEC.fieldOf("properties").forGetter(Group::properties)).apply((Applicative)instance, Group::new));

    @Override
    public boolean test(Player player) {
        return this.properties.test(player);
    }

    public record Properties(Optional<Integer> opLevelMin, Optional<Integer> opLevelMax, Optional<HashSet<String>> usernames, Optional<HashSet<String>> usernamesBlacklisted, Optional<HashSet<String>> teams, Optional<HashSet<String>> teamsBlacklisted, Optional<HashSet<GameType>> gameTypes) implements Predicate<Player>
    {
        public static Properties EMPTY = new Properties(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        public static Codec<Properties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("op_level_min").forGetter(Properties::opLevelMin), (App)Codec.INT.optionalFieldOf("op_level_max").forGetter(Properties::opLevelMax), (App)ExtraCodecs.PLAYER_NAME.listOf().optionalFieldOf("usernames").xmap(o -> o.map(HashSet::new), o -> o.map(ArrayList::new)).forGetter(Properties::usernames), (App)ExtraCodecs.PLAYER_NAME.listOf().optionalFieldOf("usernames_blacklist").xmap(o -> o.map(HashSet::new), o -> o.map(ArrayList::new)).forGetter(Properties::usernamesBlacklisted), (App)Codec.STRING.listOf().optionalFieldOf("teams").xmap(o -> o.map(HashSet::new), o -> o.map(ArrayList::new)).forGetter(Properties::teams), (App)Codec.STRING.listOf().optionalFieldOf("teams_blacklist").xmap(o -> o.map(HashSet::new), o -> o.map(ArrayList::new)).forGetter(Properties::teamsBlacklisted), (App)GameType.CODEC.listOf().optionalFieldOf("game_types").xmap(o -> o.map(HashSet::new), o -> o.map(ArrayList::new)).forGetter(Properties::gameTypes)).apply((Applicative)instance, Properties::new));

        @Override
        public boolean test(Player player) {
            ServerPlayer serverPlayer;
            if (this.equals(EMPTY)) {
                return true;
            }
            String username = player.getGameProfile().getName();
            if (this.usernamesBlacklisted.map(s -> s.contains(username)).orElse(false).booleanValue()) {
                return false;
            }
            int opLevel = ((EntityAccessor)player).callGetPermissionLevel();
            if (this.opLevelMin.map(i -> opLevel < i).orElse(false).booleanValue()) {
                return false;
            }
            if (this.opLevelMax.map(i -> opLevel > i).orElse(false).booleanValue()) {
                return false;
            }
            if (player instanceof ServerPlayer && this.gameTypes.map(arg_0 -> Properties.lambda$test$14(serverPlayer = (ServerPlayer)player, arg_0)).orElse(false).booleanValue()) {
                return false;
            }
            String team = player.getTeam() == null ? null : player.getTeam().getName();
            boolean teamFlag = this.teams.isEmpty();
            if (team != null) {
                if (this.teamsBlacklisted.map(s -> s.contains(team)).orElse(false).booleanValue()) {
                    return false;
                }
                teamFlag = this.teams.map(s -> s.contains(team)).orElse(false);
            }
            return teamFlag && this.usernames.map(s -> s.contains(username)).orElse(true) != false;
        }

        private static /* synthetic */ Boolean lambda$test$14(ServerPlayer serverPlayer, HashSet types) {
            return !types.contains(serverPlayer.gameMode.getGameModeForPlayer());
        }
    }
}

