/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.itemblacklist.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import github.pitbox46.itemblacklist.ItemBlacklist;
import github.pitbox46.itemblacklist.Utils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CommandBanItem {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ban").requires(cs -> cs.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> CommandBanItem.banItem((CommandContext<CommandSourceStack>)ctx, ItemArgument.getItem((CommandContext)ctx, (String)"item").createItemStack(1, false), "default"))).then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).executes(ctx -> CommandBanItem.banItem((CommandContext<CommandSourceStack>)ctx, ItemArgument.getItem((CommandContext)ctx, (String)"item").createItemStack(1, false), StringArgumentType.getString((CommandContext)ctx, (String)"group")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"hand").executes(ctx -> {
            ItemStack stack = ((CommandSourceStack)ctx.getSource()).getPlayerOrException().getMainHandItem();
            return CommandBanItem.banItem((CommandContext<CommandSourceStack>)ctx, stack, "default");
        })).then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).executes(ctx -> CommandBanItem.banItem((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).getPlayerOrException().getMainHandItem(), StringArgumentType.getString((CommandContext)ctx, (String)"group")))));
    }

    private static int banItem(CommandContext<CommandSourceStack> context, ItemStack stack, String group) {
        if (stack.isEmpty()) {
            return 1;
        }
        ItemBlacklist.BLACKLIST.addItem(stack.copy(), group);
        PlayerList playerList = ((CommandSourceStack)context.getSource()).getServer().getPlayerList();
        Utils.broadcastMessage(((CommandSourceStack)context.getSource()).getServer(), (Component)Component.literal((String)"Item banned: ").append(stack.getItem().toString()));
        for (ServerPlayer player : playerList.getPlayers()) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack stackInSlot = player.getInventory().getItem(i);
                if (!ItemBlacklist.shouldDelete(stackInSlot, (Player)player)) continue;
                stackInSlot.setCount(0);
            }
        }
        ItemBlacklist.BLACKLIST.recalculate();
        return 0;
    }
}

