/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.itemblacklist.mixins;

import github.pitbox46.itemblacklist.Config;
import github.pitbox46.itemblacklist.ItemBlacklist;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Inject(at={@At(value="RETURN")}, method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/item/crafting/RecipeInput;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/crafting/RecipeHolder;)Ljava/util/Optional;"}, cancellable=true)
    private <I extends RecipeInput, T extends Recipe<I>> void onGetRecipe(RecipeType<T> pRecipeType, I pInput, Level pLevel, @Nullable RecipeHolder<T> holder, CallbackInfoReturnable<Optional<RecipeHolder<T>>> cir) {
        if (Config.BAN_CRAFTING.getAsBoolean()) {
            ((Optional)cir.getReturnValue()).ifPresent(value -> cir.setReturnValue(ItemBlacklist.shouldDelete(value.value().assemble(pInput, (HolderLookup.Provider)pLevel.registryAccess())) ? Optional.empty() : Optional.of(value)));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getRecipesFor"}, cancellable=true)
    private <I extends RecipeInput, T extends Recipe<I>> void onGetRecipes(RecipeType<T> pRecipeType, I pInput, Level pLevel, CallbackInfoReturnable<List<RecipeHolder<T>>> cir) {
        if (Config.BAN_CRAFTING.getAsBoolean()) {
            cir.setReturnValue(((List)cir.getReturnValue()).stream().filter(entry -> !ItemBlacklist.shouldDelete(entry.value().assemble(pInput, (HolderLookup.Provider)pLevel.registryAccess()))).toList());
        }
    }
}

