/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.onboarding;

import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceList;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingScreenBase;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class DeviceOnboardingScreen
extends OnboardingScreenBase {
    protected AudioDeviceList deviceList;
    protected List<String> micNames;

    public DeviceOnboardingScreen(Component title, @Nullable Screen previous) {
        super(title, previous);
        this.minecraft = Minecraft.getInstance();
        this.micNames = this.getNames();
        if (this.micNames.isEmpty()) {
            this.minecraft.tell(() -> this.minecraft.setScreen(this.getNextScreen()));
        }
    }

    public abstract List<String> getNames();

    public abstract ResourceLocation getIcon();

    public abstract ConfigEntry<String> getConfigEntry();

    @Override
    protected void init() {
        super.init();
        if (this.deviceList != null) {
            Objects.requireNonNull(this.font);
            Objects.requireNonNull(this.font);
            this.deviceList.setRectangle(this.width, this.contentHeight - 9 - 20 - 16, 0, this.guiTop + 9 + 8);
        } else {
            Objects.requireNonNull(this.font);
            Objects.requireNonNull(this.font);
            this.deviceList = new AudioDeviceList(this.width, this.contentHeight - 9 - 20 - 16, this.guiTop + 9 + 8).setIcon(this.getIcon()).setConfigEntry(this.getConfigEntry());
        }
        this.deviceList.setAudioDevices(this.getNames());
        this.addWidget((GuiEventListener)this.deviceList);
        this.addBackOrCancelButton();
        this.addNextButton();
    }

    @Override
    public abstract Screen getNextScreen();

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.deviceList.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTitle(guiGraphics, this.title);
    }
}

