/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.aether.client.sound.MusicSoundInstance;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.mixin.mixins.client.accessor.BossHealthOverlayAccessor;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class AetherMusicManager {
    private static final int FADE_LIMIT = 50;
    private static final RandomSource random = RandomSource.create();
    private static final Minecraft minecraft = Minecraft.getInstance();
    private static final MusicManager musicManager = Minecraft.getInstance().getMusicManager();
    @Nullable
    private static SoundInstance currentMusic;
    private static int nextSongDelay;
    private static Integer fade;

    public static void tick() {
        Music music = AetherMusicManager.getSituationalMusic();
        Object object = currentMusic;
        if (object instanceof MusicSoundInstance) {
            MusicSoundInstance musicSoundInstance = (MusicSoundInstance)((Object)object);
            if (musicSoundInstance.isBossMusic()) {
                if (music == null || !AetherMusicManager.isAetherBossMusic(music)) {
                    if (fade == null) {
                        fade = 0;
                    }
                    musicSoundInstance.setVolume((float)Math.exp(-((double)fade.intValue() / 16.666666666666668)));
                    object = fade;
                    fade = fade + 1;
                    if (fade >= 50) {
                        fade = null;
                        minecraft.getSoundManager().stop(currentMusic);
                        currentMusic = null;
                        nextSongDelay = Math.min(Integer.MAX_VALUE, Mth.nextInt((RandomSource)random, (int)((Integer)AetherConfig.CLIENT.music_backup_min_delay.get()), (int)((Integer)AetherConfig.CLIENT.music_backup_max_delay.get() / 2)));
                    }
                }
            } else if (music != null && AetherMusicManager.isAetherBossMusic(music)) {
                if (fade == null) {
                    fade = 0;
                }
                musicSoundInstance.setVolume((float)Math.exp(-((double)fade.intValue() / 16.666666666666668)));
                object = fade;
                fade = fade + 1;
                if (fade >= 50) {
                    fade = null;
                    minecraft.getSoundManager().stop(currentMusic);
                    currentMusic = null;
                    nextSongDelay = 16;
                }
            }
        }
        if (music != null) {
            if (currentMusic != null && fade == null) {
                if (!((SoundEvent)music.getEvent().value()).getLocation().equals((Object)currentMusic.getLocation()) && music.replaceCurrentMusic()) {
                    minecraft.getSoundManager().stop(currentMusic);
                    nextSongDelay = Mth.nextInt((RandomSource)random, (int)0, (int)(music.getMinDelay() / 2));
                }
                if (!minecraft.getSoundManager().isActive(currentMusic)) {
                    currentMusic = null;
                    nextSongDelay = Math.min(nextSongDelay, Mth.nextInt((RandomSource)random, (int)music.getMinDelay(), (int)music.getMaxDelay()));
                }
            }
            nextSongDelay = Math.min(nextSongDelay, music.getMaxDelay());
            if (currentMusic == null && nextSongDelay-- <= 0) {
                AetherMusicManager.startPlaying(music);
            }
        } else if (currentMusic == null || !minecraft.getSoundManager().isActive(currentMusic)) {
            currentMusic = null;
            if (nextSongDelay-- <= 0) {
                nextSongDelay = Math.min(Integer.MAX_VALUE, Mth.nextInt((RandomSource)random, (int)((Integer)AetherConfig.CLIENT.music_backup_min_delay.get()), (int)((Integer)AetherConfig.CLIENT.music_backup_max_delay.get())));
            }
        }
    }

    public static void startPlaying(Music music) {
        musicManager.stopPlaying();
        currentMusic = AetherMusicManager.isAetherBossMusic(music) ? MusicSoundInstance.forBossMusic((SoundEvent)music.getEvent().value()) : MusicSoundInstance.forMusic((SoundEvent)music.getEvent().value());
        if (currentMusic.getSound() != SoundManager.EMPTY_SOUND) {
            minecraft.getSoundManager().play(currentMusic);
        }
        nextSongDelay = Integer.MAX_VALUE;
    }

    public static void stopPlaying() {
        if (currentMusic != null) {
            minecraft.getSoundManager().stop(currentMusic);
            currentMusic = null;
        }
        nextSongDelay += 100;
    }

    @Nullable
    public static SoundInstance getCurrentMusic() {
        return currentMusic;
    }

    @Nullable
    public static <T extends LivingEntity> Music getSituationalMusic() {
        if (!(AetherMusicManager.minecraft.screen instanceof WinScreen) && AetherMusicManager.minecraft.player != null) {
            if (AetherMusicManager.isAetherBossMusicActive()) {
                Music bossMusic;
                T boss = AetherMusicManager.getBossFromFight();
                if (boss != null && boss.getHealth() > 0.0f && (bossMusic = ((AetherBossMob)boss).getBossMusic()) != null) {
                    return ((AetherBossMob)boss).getBossMusic();
                }
            } else {
                Holder holder = AetherMusicManager.minecraft.player.level().getBiome(AetherMusicManager.minecraft.player.blockPosition());
                if (AetherMusicManager.isCreative((Holder<Biome>)holder, (Player)AetherMusicManager.minecraft.player)) {
                    return ((Biome)holder.value()).getBackgroundMusic().orElse(Musics.GAME);
                }
            }
        }
        return null;
    }

    public static boolean isAetherBossMusic(Music music) {
        return music.getEvent().is(AetherTags.SoundEvents.BOSS_MUSIC);
    }

    public static boolean isAetherBossMusicActive() {
        return (Boolean)AetherConfig.CLIENT.disable_aether_boss_music.get() == false && !AetherMusicManager.getAetherBossFights().isEmpty() && AetherMusicManager.minecraft.gui.getBossOverlay().shouldPlayMusic();
    }

    public static Map<UUID, LerpingBossEvent> getAetherBossFights() {
        return ((BossHealthOverlayAccessor)AetherMusicManager.minecraft.gui.getBossOverlay()).getEvents().entrySet().stream().filter(entry -> GuiHooks.isAetherBossBar((UUID)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <T extends LivingEntity> T getBossFromFight() {
        for (Map.Entry<UUID, LerpingBossEvent> event : AetherMusicManager.getAetherBossFights().entrySet()) {
            UUID eventUUID = event.getKey();
            int entityId = GuiHooks.BOSS_EVENTS.get(eventUUID);
            Entity entity = AetherMusicManager.minecraft.player.level().getEntity(entityId);
            if (!(entity instanceof LivingEntity) || !(entity instanceof AetherBossMob)) continue;
            return (T)((LivingEntity)entity);
        }
        return null;
    }

    public static boolean isCreative(Holder<Biome> holder, Player player) {
        return player.level().dimension() != Level.END && player.level().dimension() != Level.NETHER && holder.is(AetherTags.Biomes.AETHER_MUSIC) && !musicManager.isPlayingMusic(Musics.UNDER_WATER) && (!player.isUnderWater() || !holder.is(BiomeTags.PLAYS_UNDERWATER_MUSIC)) && player.getAbilities().instabuild && player.mayFly();
    }

    static {
        nextSongDelay = 100;
        fade = null;
    }
}

