/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.client.AetherKeys;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;

public class CapabilityClientHooks {

    public static class AetherPlayerHooks {
        public static void movementInput(Player player, Input input) {
            boolean isMoving;
            boolean isJumping = input.jumping;
            AetherPlayerAttachment aetherPlayer = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
            if (isJumping != aetherPlayer.isJumping()) {
                aetherPlayer.setSynched(player.getId(), INBTSynchable.Direction.SERVER, "setJumping", isJumping);
            }
            boolean bl = isMoving = isJumping || input.up || input.down || input.left || input.right || player.isFallFlying();
            if (isMoving != aetherPlayer.isMoving()) {
                aetherPlayer.setSynched(player.getId(), INBTSynchable.Direction.SERVER, "setMoving", isMoving);
            }
        }

        public static void mouseInput(int button) {
            AetherPlayerHooks.checkHit(button);
            AetherPlayerHooks.checkJumpAbility(button);
        }

        public static void keyInput(int key) {
            AetherPlayerHooks.checkHit(key);
            AetherPlayerHooks.checkJumpAbility(key);
        }

        private static void checkHit(int input) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                boolean isHitting;
                AetherPlayerAttachment aetherPlayer = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                boolean isAttack = input == Minecraft.getInstance().options.keyAttack.getKey().getValue();
                boolean isPressing = Minecraft.getInstance().options.keyAttack.isDown();
                boolean bl = isHitting = isAttack && isPressing;
                if (isHitting != aetherPlayer.isHitting()) {
                    aetherPlayer.setSynched(player.getId(), INBTSynchable.Direction.SERVER, "setHitting", isHitting);
                }
            }
        }

        private static void checkJumpAbility(int input) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                AetherPlayerAttachment aetherPlayer = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                if (input == AetherKeys.GRAVITITE_JUMP_ABILITY.getKey().getValue()) {
                    aetherPlayer.setSynched(player.getId(), INBTSynchable.Direction.SERVER, "setGravititeJumpActive", AetherKeys.GRAVITITE_JUMP_ABILITY.isDown());
                }
            }
        }
    }
}

