/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.component.inventory;

import com.aetherteam.aether.client.gui.screen.inventory.AetherAccessoriesScreen;
import com.aetherteam.aether.inventory.menu.AetherAccessoriesMenu;
import com.aetherteam.aether.network.packet.serverbound.OpenAccessoriesPacket;
import com.aetherteam.aether.network.packet.serverbound.OpenInventoryPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class AccessoryButton
extends ImageButton {
    private final AbstractContainerScreen<?> parentScreen;

    public AccessoryButton(AbstractContainerScreen<?> parentScreen, int x, int y, WidgetSprites sprites) {
        super(x, y, 12, 8, sprites, button -> {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                ItemStack stack = player.containerMenu.getCarried();
                player.containerMenu.setCarried(ItemStack.EMPTY);
                if (parentScreen instanceof AetherAccessoriesScreen) {
                    InventoryScreen inventory = new InventoryScreen((Player)player);
                    minecraft.setScreen((Screen)inventory);
                    player.inventoryMenu.setCarried(stack);
                    PacketDistributor.sendToServer((CustomPacketPayload)new OpenInventoryPacket(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToServer((CustomPacketPayload)new OpenAccessoriesPacket(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
        this.parentScreen = parentScreen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Tuple<Integer, Integer> offsets = AetherAccessoriesScreen.getButtonOffset(this.parentScreen);
        this.setX(this.parentScreen.getGuiLeft() + (Integer)offsets.getA());
        this.setY(this.parentScreen.getGuiTop() + (Integer)offsets.getB());
        AbstractContainerScreen<?> abstractContainerScreen = this.parentScreen;
        if (abstractContainerScreen instanceof CreativeModeInventoryScreen) {
            boolean isInventoryTab;
            CreativeModeInventoryScreen screen = (CreativeModeInventoryScreen)abstractContainerScreen;
            this.active = isInventoryTab = screen.isInventoryOpen();
            if (isInventoryTab) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            }
        } else {
            abstractContainerScreen = this.parentScreen;
            if (abstractContainerScreen instanceof AetherAccessoriesScreen) {
                AetherAccessoriesScreen screen = (AetherAccessoriesScreen)abstractContainerScreen;
                if (((AetherAccessoriesMenu)screen.getMenu()).hasButton) {
                    super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
                }
            } else {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            }
        }
    }
}

