/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.inventory;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.AetherKeys;
import com.aetherteam.aether.client.gui.screen.inventory.RecipeBookBehavior;
import com.aetherteam.aether.client.gui.screen.perks.AetherCustomizationsScreen;
import com.aetherteam.aether.client.gui.screen.perks.MoaSkinsScreen;
import com.aetherteam.aether.inventory.menu.AetherAccessoriesMenu;
import com.aetherteam.aether.mixin.mixins.client.accessor.ScreenAccessor;
import com.aetherteam.aether.network.packet.serverbound.ClearItemPacket;
import com.aetherteam.aether.perk.PerkUtil;
import com.aetherteam.nitrogen.api.users.User;
import com.aetherteam.nitrogen.api.users.UserData;
import com.mojang.blaze3d.platform.InputConstants;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.client.gui.ToggleButton;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.NukeAccessories;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class AetherAccessoriesScreen
extends EffectRenderingInventoryScreen<AetherAccessoriesMenu>
implements RecipeUpdateListener,
RecipeBookBehavior<AetherAccessoriesMenu, AetherAccessoriesScreen> {
    public static final WidgetSprites ACCESSORIES_BUTTON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"inventory/accessories_button"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"inventory/accessories_button_highlighted"));
    public static final WidgetSprites SKINS_BUTTON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"skins/skins_button"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"skins/skins_button_highlighted"));
    public static final WidgetSprites CUSTOMIZATION_BUTTON = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"customization/customization_button"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"customization/customization_button_highlighted"));
    private static final ResourceLocation ACCESSORIES_INVENTORY = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/gui/inventory/accessories.png");
    private static final ResourceLocation ACCESSORIES_INVENTORY_CREATIVE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/gui/inventory/accessories_creative.png");
    private static final SimpleContainer DESTROY_ITEM_CONTAINER = new SimpleContainer(1);
    private final Map<AccessoriesBasedSlot, ToggleButton> cosmeticButtons = new LinkedHashMap<AccessoriesBasedSlot, ToggleButton>();
    private final RecipeBookComponent recipeBookComponent = new RecipeBookComponent();
    private boolean widthTooNarrow;
    private boolean buttonClicked;
    private boolean isRenderButtonHovered;
    @Nullable
    private Slot destroyItemSlot;
    private int nukeCoolDown = 0;

    public AetherAccessoriesScreen(AetherAccessoriesMenu accessoriesMenu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)accessoriesMenu, playerInventory, title);
    }

    public void init() {
        super.init();
        if (this.getMinecraft().player != null) {
            this.imageWidth = this.getMinecraft().player.isCreative() ? 176 + this.creativeXOffset() : 176;
        }
        this.widthTooNarrow = this.width < 379;
        this.getRecipeBookComponent().init(this.width, this.height, this.getMinecraft(), this.widthTooNarrow, (RecipeBookMenu)this.getMenu());
        this.updateScreenPosition();
        this.addWidget((GuiEventListener)this.getRecipeBookComponent());
        this.setInitialFocus((GuiEventListener)this.getRecipeBookComponent());
        if (this.getMinecraft().player != null && this.getRecipeBookComponent().isVisible()) {
            this.getRecipeBookComponent().toggleVisibility();
            this.updateScreenPosition();
        }
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.getGuiLeft() + 142, this.height / 2 - 22, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, pressed -> {
            this.getRecipeBookComponent().toggleVisibility();
            this.updateScreenPosition();
            pressed.setPosition(this.getGuiLeft() + 142, this.height / 2 - 22);
            this.buttonClicked = true;
        }));
        this.updateRenderButtons();
        User user = UserData.Client.getClientUser();
        if (user != null) {
            if (!((Boolean)AetherConfig.CLIENT.disable_skins_button.get()).booleanValue() || PerkUtil.hasAnyMoaSkins().test(user)) {
                ImageButton skinsButton = this.createSkinsButton();
                this.addRenderableWidget((GuiEventListener)skinsButton);
            }
            if (PerkUtil.hasDeveloperGlow().test(user) || PerkUtil.hasHalo().test(user)) {
                ImageButton customizationButton = this.createCustomizationButton();
                this.addRenderableWidget((GuiEventListener)customizationButton);
            }
        }
    }

    protected void containerTick() {
        if (this.nukeCoolDown > 0) {
            --this.nukeCoolDown;
        }
        RecipeBookBehavior.super.containerTick(this);
    }

    private void updateScreenPosition() {
        int i;
        if (this.getRecipeBookComponent().isVisible() && !this.widthTooNarrow) {
            int offset = 200 - this.creativeXOffset();
            i = 177 + (this.width - this.getXSize() - offset) / 2;
        } else {
            i = (this.width - this.getXSize()) / 2;
        }
        this.leftPos = i;
        this.updateRenderButtons();
    }

    private ImageButton createSkinsButton() {
        ImageButton skinsButton = new ImageButton(this.getGuiLeft() - 22, this.getGuiTop() + 2, 20, 20, SKINS_BUTTON, pressed -> this.getMinecraft().setScreen((Screen)new MoaSkinsScreen((Screen)this)), (Component)Component.translatable((String)"gui.aether.accessories.skins_button")){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                if (!AetherAccessoriesScreen.this.getRecipeBookComponent().isVisible()) {
                    this.setX(AetherAccessoriesScreen.this.getGuiLeft() - 22);
                    this.setY(AetherAccessoriesScreen.this.getGuiTop() + 2);
                } else {
                    this.setX(AetherAccessoriesScreen.this.getGuiLeft() + 2);
                    this.setY(AetherAccessoriesScreen.this.getGuiTop() - 22);
                }
            }
        };
        skinsButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.aether.accessories.skins_button")));
        return skinsButton;
    }

    private ImageButton createCustomizationButton() {
        ImageButton customizationButton = new ImageButton(this.getGuiLeft() - 22, this.getGuiTop() + 24, 20, 20, CUSTOMIZATION_BUTTON, pressed -> this.getMinecraft().setScreen((Screen)new AetherCustomizationsScreen((Screen)this)), (Component)Component.translatable((String)"gui.aether.accessories.customization_button")){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                if (!AetherAccessoriesScreen.this.getRecipeBookComponent().isVisible()) {
                    this.setX(AetherAccessoriesScreen.this.getGuiLeft() - 22);
                    this.setY(AetherAccessoriesScreen.this.getGuiTop() + 24);
                } else {
                    this.setX(AetherAccessoriesScreen.this.getGuiLeft() + 24);
                    this.setY(AetherAccessoriesScreen.this.getGuiTop() - 22);
                }
            }
        };
        customizationButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.aether.accessories.customization_button")));
        return customizationButton;
    }

    private void updateRenderButtons() {
        ScreenAccessor screenAccessor = (ScreenAccessor)((Object)this);
        screenAccessor.aether$getNarratables().removeIf(widget -> widget instanceof ToggleButton);
        this.children().removeIf(widget -> widget instanceof ToggleButton);
        this.cosmeticButtons.clear();
        for (Slot slot : ((AetherAccessoriesMenu)this.menu).slots) {
            if (!(slot instanceof AccessoriesBasedSlot)) continue;
            AccessoriesBasedSlot accessoriesSlot = (AccessoriesBasedSlot)slot;
            ToggleButton slotButton = ToggleButton.ofSlot((int)(slot.x + this.leftPos + 13), (int)(slot.y + this.topPos - 2), (int)0, (AccessoriesBasedSlot)accessoriesSlot);
            slotButton.visible = accessoriesSlot.isActive();
            slotButton.active = accessoriesSlot.isActive();
            this.cosmeticButtons.put(accessoriesSlot, (ToggleButton)this.addWidget((GuiEventListener)slotButton));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getRecipeBookComponent().isVisible() && this.widthTooNarrow) {
            this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
            this.getRecipeBookComponent().render(guiGraphics, mouseX, mouseY, partialTicks);
        } else {
            Slot slot;
            this.getRecipeBookComponent().render(guiGraphics, mouseX, mouseY, partialTicks);
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.getRecipeBookComponent().renderGhostRecipe(guiGraphics, this.getGuiLeft(), this.getGuiTop(), false, partialTicks);
            for (ToggleButton toggleButton : this.cosmeticButtons.values()) {
                toggleButton.render(guiGraphics, mouseX, mouseY, partialTicks);
            }
            boolean isButtonHovered = false;
            for (GuiEventListener widget : this.children()) {
                ToggleButton renderButton;
                if (!(widget instanceof ToggleButton) || !(renderButton = (ToggleButton)widget).isHovered()) continue;
                isButtonHovered = true;
            }
            this.isRenderButtonHovered = isButtonHovered;
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (!this.isRenderButtonHovered && localPlayer != null && localPlayer.inventoryMenu.getCarried().isEmpty() && this.getSlotUnderMouse() != null && (slot = this.getSlotUnderMouse()) instanceof AccessoriesBasedSlot) {
                AccessoriesBasedSlot accessorySlot = (AccessoriesBasedSlot)slot;
                if (!slot.hasItem()) {
                    guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)accessorySlot.slotType().translation()), mouseX, mouseY);
                }
            }
            if (this.getMinecraft().player != null) {
                if (this.getMinecraft().player.isCreative() && this.destroyItemSlot == null) {
                    this.destroyItemSlot = new Slot((Container)DESTROY_ITEM_CONTAINER, 0, 172, 142);
                    ((AetherAccessoriesMenu)this.getMenu()).slots.add((Object)this.destroyItemSlot);
                } else if (!this.getMinecraft().player.isCreative() && this.destroyItemSlot != null) {
                    ((AetherAccessoriesMenu)this.getMenu()).slots.remove((Object)this.destroyItemSlot);
                    this.destroyItemSlot = null;
                }
            }
            if (this.destroyItemSlot != null && this.isHovering(this.destroyItemSlot.x, this.destroyItemSlot.y, 16, 16, mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"inventory.binSlot"), mouseX, mouseY);
            }
            if (this.getMinecraft().player != null) {
                this.imageWidth = this.getMinecraft().player.isCreative() ? 176 + this.creativeXOffset() : 176;
            }
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.getRecipeBookComponent().renderTooltip(guiGraphics, this.getGuiLeft(), this.getGuiTop(), mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        if (this.getMinecraft().player != null) {
            int i = this.getGuiLeft();
            int j = this.getGuiTop();
            guiGraphics.blit(this.getMinecraft().player.isCreative() ? ACCESSORIES_INVENTORY_CREATIVE : ACCESSORIES_INVENTORY, i, j, 0, 0, this.getXSize() + this.creativeXOffset(), this.getYSize());
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(i + 9), (int)(j + 8), (int)(i + 58), (int)(j + 78), (int)30, (float)0.1575f, (float)mouseX, (float)mouseY, (LivingEntity)this.getMinecraft().player);
        }
    }

    private int creativeXOffset() {
        return this.getMinecraft().player != null && this.getMinecraft().player.isCreative() ? 18 : 0;
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = this.getMinecraft();
        LocalPlayer clientPlayer = minecraft.player;
        if (clientPlayer != null && clientPlayer.inventoryMenu.getCarried().isEmpty() && !this.isRenderButtonHovered && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            guiGraphics.renderTooltip(this.font, this.hoveredSlot.getItem(), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.getMinecraft().player != null) {
            guiGraphics.drawString(this.font, this.title, 115, 6, 0x404040, false);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getRecipeBookComponent().isVisible() && this.widthTooNarrow) {
            this.getRecipeBookComponent().toggleVisibility();
            this.updateScreenPosition();
            return true;
        }
        if (AetherKeys.OPEN_ACCESSORY_INVENTORY.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().player;
            if (playerEntity != null) {
                playerEntity.closeContainer();
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean isHovering(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        if (this.isRenderButtonHovered) {
            return false;
        }
        return (!this.widthTooNarrow || !this.getRecipeBookComponent().isVisible()) && super.isHovering(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.getRecipeBookComponent().mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.getRecipeBookComponent());
            return true;
        }
        return (!this.widthTooNarrow || !this.getRecipeBookComponent().isVisible()) && super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return RecipeBookBehavior.super.hasClickedOutside(this, mouseX, mouseY, guiLeft, guiTop, mouseButton);
    }

    protected void slotClicked(@Nullable Slot slot, int slotId, int mouseButton, ClickType type) {
        RecipeBookBehavior.super.slotClicked(this, slot);
        if (this.getMinecraft().player != null && this.getMinecraft().gameMode != null) {
            boolean flag;
            boolean bl = flag = type == ClickType.QUICK_MOVE;
            if (!(slot == null && type != ClickType.QUICK_CRAFT || slot != null && !slot.mayPickup((Player)this.getMinecraft().player))) {
                if (slot == this.destroyItemSlot && this.destroyItemSlot != null && flag) {
                    for (int j = 0; j < this.getMinecraft().player.inventoryMenu.getItems().size(); ++j) {
                        if (this.nukeCoolDown <= 0) {
                            AccessoriesNetworking.sendToServer((Record)new NukeAccessories());
                            this.nukeCoolDown = 10;
                        }
                        this.getMinecraft().gameMode.handleCreativeModeItemAdd(ItemStack.EMPTY, j);
                    }
                } else if (slot == this.destroyItemSlot && this.destroyItemSlot != null) {
                    ((AetherAccessoriesMenu)this.getMenu()).setCarried(ItemStack.EMPTY);
                    PacketDistributor.sendToServer((CustomPacketPayload)new ClearItemPacket(this.getMinecraft().player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            super.slotClicked(slot, slotId, mouseButton, type);
        }
    }

    public void recipesUpdated() {
        RecipeBookBehavior.super.recipesUpdated(this);
    }

    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookComponent;
    }

    public boolean canSeeEffects() {
        int i = this.getGuiLeft() + this.getXSize() + 2 + this.creativeXOffset();
        int j = this.width - i;
        return j > 13;
    }

    public static Tuple<Integer, Integer> getButtonOffset(Screen screen) {
        int x = 0;
        int y = 0;
        if (screen instanceof InventoryScreen || screen instanceof AccessoriesScreen) {
            x = (Integer)AetherConfig.CLIENT.button_inventory_x.get();
            y = (Integer)AetherConfig.CLIENT.button_inventory_y.get();
        }
        if (screen instanceof CreativeModeInventoryScreen) {
            x = (Integer)AetherConfig.CLIENT.button_creative_x.get();
            y = (Integer)AetherConfig.CLIENT.button_creative_y.get();
        }
        if (screen instanceof AetherAccessoriesScreen) {
            x = (Integer)AetherConfig.CLIENT.button_accessories_x.get();
            y = (Integer)AetherConfig.CLIENT.button_accessories_y.get();
        }
        return new Tuple((Object)x, (Object)y);
    }
}

