/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.menu;

import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.aetherteam.cumulus.CumulusConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.internal.BrandingControl;

public interface TitleScreenBehavior {
    default public float handleFading(GuiGraphics guiGraphics, TitleScreen titleScreen, TitleScreenAccessor titleScreenAccessor, PanoramaRenderer panorama, ResourceLocation panoramaOverlay, float partialTicks) {
        if (titleScreenAccessor.aether$getFadeInStart() == 0L && titleScreenAccessor.aether$isFading()) {
            titleScreenAccessor.aether$setFadeInStart(Util.getMillis());
        }
        float fadeAmount = titleScreenAccessor.aether$isFading() ? (float)(Util.getMillis() - titleScreenAccessor.aether$getFadeInStart()) / 1000.0f : 1.0f;
        panorama.render(guiGraphics, titleScreen.width, titleScreen.height, Mth.clamp((float)fadeAmount, (float)0.0f, (float)1.0f), partialTicks);
        RenderSystem.enableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, titleScreenAccessor.aether$isFading() ? (float)Mth.ceil((float)Mth.clamp((float)fadeAmount, (float)0.0f, (float)1.0f)) : 1.0f);
        guiGraphics.blit(panoramaOverlay, 0, 0, titleScreen.width, titleScreen.height, 0.0f, 0.0f, 16, 128, 16, 128);
        return titleScreenAccessor.aether$isFading() ? Mth.clamp((float)(fadeAmount - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
    }

    default public void renderRightBranding(GuiGraphics guiGraphics, TitleScreen titleScreen, Font font, int roundedFadeAmount) {
        BrandingControl.forEachLine((boolean)true, (boolean)true, (brandingLine, branding) -> {
            int n = titleScreen.width - font.width(branding) - 1;
            int n2 = titleScreen.height;
            int n3 = brandingLine + 1;
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, branding, n, n2 - (10 + n3 * (9 + 1)), 0xFFFFFF | roundedFadeAmount);
        });
        BrandingControl.forEachAboveCopyrightLine((brandingLine, branding) -> {
            int n = titleScreen.height;
            int n2 = brandingLine + 1;
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, branding, 1, n - n2 * (9 + 1), 0xFFFFFF | roundedFadeAmount);
        });
    }

    default public int handleButtonVisibility(TitleScreen titleScreen, float fadeAmount) {
        for (GuiEventListener guiEventListener : titleScreen.children()) {
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget = (AbstractWidget)guiEventListener;
            if (fadeAmount > 0.02f) {
                if (TitleScreenBehavior.isImageButton(abstractWidget.getMessage())) continue;
                abstractWidget.setAlpha(fadeAmount);
                abstractWidget.visible = true;
                continue;
            }
            abstractWidget.visible = false;
        }
        return (Boolean)CumulusConfig.CLIENT.enable_menu_api.get() != false && (Boolean)CumulusConfig.CLIENT.enable_menu_list_button.get() != false ? -62 : 0;
    }

    default public void handleImageButtons(TitleScreen titleScreen, int xOffset) {
        for (Renderable renderable : titleScreen.renderables) {
            if (!(renderable instanceof Button)) continue;
            Button button = (Button)renderable;
            Component buttonText = button.getMessage();
            if (TitleScreenBehavior.isImageButton(buttonText)) {
                button.visible = true;
            }
            if (buttonText.equals((Object)Component.translatable((String)"options.accessibility"))) {
                button.setX(titleScreen.width - 48 + xOffset);
                button.setY(4);
                continue;
            }
            if (!buttonText.equals((Object)Component.translatable((String)"options.language"))) continue;
            button.setX(titleScreen.width - 24 + xOffset);
            button.setY(4);
        }
    }

    public static boolean isImageButton(Component buttonText) {
        return buttonText.equals((Object)Component.translatable((String)"options.accessibility")) || buttonText.equals((Object)Component.translatable((String)"options.language"));
    }

    public static boolean isMainButton(Component buttonText) {
        return buttonText.equals((Object)Component.translatable((String)"menu.singleplayer")) || buttonText.equals((Object)Component.translatable((String)"menu.multiplayer")) || buttonText.equals((Object)Component.translatable((String)"gui.aether.menu.server")) || buttonText.equals((Object)Component.translatable((String)"menu.online")) || buttonText.equals((Object)Component.translatable((String)"fml.menu.mods")) || buttonText.equals((Object)Component.translatable((String)"menu.options")) || buttonText.equals((Object)Component.translatable((String)"menu.quit"));
    }
}

