/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.NotGrounded;
import com.aetherteam.aether.entity.WingedBird;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public abstract class BipedBirdModel<T extends Entity & NotGrounded>
extends EntityModel<T> {
    public final ModelPart head;
    public final ModelPart jaw;
    public final ModelPart neck;
    public final ModelPart body;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart rightWing;
    public final ModelPart leftWing;
    public final ModelPart rightTailFeather;
    public final ModelPart middleTailFeather;
    public final ModelPart leftTailFeather;

    public BipedBirdModel(ModelPart root) {
        this.head = root.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.neck = this.head.getChild("neck");
        this.body = root.getChild("body");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
        this.rightTailFeather = root.getChild("right_tail_feather");
        this.middleTailFeather = root.getChild("middle_tail_feather");
        this.leftTailFeather = root.getChild("left_tail_feather");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cube) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).addBox(-2.0f, -4.0f, -6.0f, 4.0f, 4.0f, 8.0f, cube, 0.5f, 0.5f), PartPose.offset((float)0.0f, (float)8.0f, (float)-4.0f));
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(24, 13).addBox(-2.0f, -1.0f, -6.0f, 4.0f, 1.0f, 8.0f, new CubeDeformation(-0.1f), 0.5f, 0.5f), PartPose.ZERO);
        head.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, cube, 0.5f, 0.5f), PartPose.ZERO);
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 8.0f, 5.0f, cube, 0.5f, 0.5f), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(54, 21).addBox(-0.99f, -1.0f, -1.0f, 2.0f, 9.0f, 2.0f, cube, 0.5f, 0.5f), PartPose.offset((float)-2.0f, (float)16.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(46, 21).addBox(-1.01f, -1.0f, -1.0f, 2.0f, 9.0f, 2.0f, cube, 0.5f, 0.5f), PartPose.offset((float)2.0f, (float)16.0f, (float)1.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 8.0f, 4.0f, cube, 0.5f, 0.5f), PartPose.offset((float)-3.001f, (float)-3.0f, (float)3.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(30, 0).addBox(0.0f, 0.0f, -2.0f, 1.0f, 8.0f, 4.0f, cube, 0.5f, 0.5f), PartPose.offset((float)3.001f, (float)-3.0f, (float)3.0f));
        partDefinition.addOrReplaceChild("right_tail_feather", CubeListBuilder.create().texOffs(0, 26).addBox(-1.0f, -5.0f, 5.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(-0.3f), 0.5f, 0.5f), PartPose.offsetAndRotation((float)0.0f, (float)17.5f, (float)1.0f, (float)0.25f, (float)-0.375f, (float)0.0f));
        partDefinition.addOrReplaceChild("middle_tail_feather", CubeListBuilder.create().texOffs(14, 26).addBox(-1.0f, -5.0f, 5.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(-0.3f), 0.5f, 0.5f), PartPose.offsetAndRotation((float)0.0f, (float)17.5f, (float)1.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_tail_feather", CubeListBuilder.create().texOffs(28, 26).addBox(-1.0f, -5.0f, 5.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(-0.3f), 0.5f, 0.5f), PartPose.offsetAndRotation((float)0.0f, (float)17.5f, (float)1.0f, (float)0.25f, (float)0.375f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public void setupAnim(T bipedBird, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.neck.xRot = -this.head.xRot;
        if (!((NotGrounded)bipedBird).isEntityOnGround()) {
            this.rightWing.setPos(-3.001f, 0.0f, 4.0f);
            this.leftWing.setPos(3.001f, 0.0f, 4.0f);
            this.leftWing.xRot = this.rightWing.xRot = -1.5707964f;
            this.leftLeg.xRot = this.rightLeg.xRot = 0.6f;
            this.rightWing.yRot = ageInTicks;
        } else {
            this.rightWing.setPos(-3.001f, -3.0f, 3.0f);
            this.leftWing.setPos(3.001f, -3.0f, 3.0f);
            this.rightWing.xRot = 0.0f;
            this.leftWing.xRot = 0.0f;
            this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightWing.yRot = 0.0f;
        }
        this.leftWing.yRot = -this.rightWing.yRot;
    }

    public float setupWingsAnimation(T bipedBird, float partialTicks) {
        float rotVal = Mth.lerp((float)partialTicks, (float)((WingedBird)bipedBird).getPrevWingRotation(), (float)((WingedBird)bipedBird).getWingRotation());
        float destVal = Mth.lerp((float)partialTicks, (float)((WingedBird)bipedBird).getPrevWingDestPos(), (float)((WingedBird)bipedBird).getWingDestPos());
        return (Mth.sin((float)(rotVal * 0.225f)) + 1.0f) * destVal;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.rightTailFeather.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.middleTailFeather.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.leftTailFeather.render(poseStack, consumer, packedLight, packedOverlay, color);
    }
}

