/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.command;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.network.packet.clientbound.HealthResetPacket;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlayerCapabilityCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"aether").then(((LiteralArgumentBuilder)Commands.literal((String)"player").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"life_shards").then(Commands.literal((String)"set").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).suggests((context, builder) -> {
            PlayerList playerlist = ((CommandSourceStack)context.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerlist.getPlayers().stream().map(player -> player.getGameProfile().getName()), (SuggestionsBuilder)builder);
        }).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)10)).executes(context -> PlayerCapabilityCommand.setLifeShards((CommandSourceStack)context.getSource(), GameProfileArgument.getGameProfiles((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))))));
    }

    private static int setLifeShards(CommandSourceStack source, Collection<GameProfile> gameProfiles, int value) {
        ServerLevel level = source.getLevel();
        PlayerList playerList = source.getServer().getPlayerList();
        for (GameProfile gameProfile : gameProfiles) {
            ServerPlayer player = playerList.getPlayer(gameProfile.getId());
            if (player == null) continue;
            AetherPlayerAttachment data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
            data.setSynched(player.getId(), INBTSynchable.Direction.CLIENT, "setLifeShardCount", value);
            AttributeInstance attribute = player.getAttribute(Attributes.MAX_HEALTH);
            if (attribute != null) {
                attribute.removeModifier(data.getLifeShardHealthAttributeModifier().id());
            }
            player.setHealth(player.getMaxHealth());
            PacketDistributor.sendToPlayersNear((ServerLevel)level, (ServerPlayer)player, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (double)5.0, (CustomPacketPayload)new HealthResetPacket(player.getId(), value), (CustomPacketPayload[])new CustomPacketPayload[0]);
            source.sendSuccess(() -> Component.translatable((String)"commands.aether.capability.player.life_shards.set", (Object[])new Object[]{player.getDisplayName(), value}), true);
        }
        return 1;
    }
}

