/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.ai.goal.ContinuousMeleeAttackGoal;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;

public class FireMinion
extends Monster {
    public FireMinion(EntityType<? extends FireMinion> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new ContinuousMeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new FallingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 15.0).add(Attributes.MAX_HEALTH, 40.0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            String name;
            SimpleParticleType particle = ParticleTypes.FLAME;
            if (this.hasCustomName() && ((name = this.getName().getString()).equals("JorgeQ") || name.equals("Jorge_SunSpirit"))) {
                particle = ParticleTypes.ITEM_SNOWBALL;
            }
            for (int i = 0; i < 1; ++i) {
                double d = this.getRandom().nextFloat() - 0.5f;
                double d1 = this.getRandom().nextFloat();
                double d2 = this.getRandom().nextFloat() - 0.5f;
                double x = this.getX() + d * d1;
                double y = this.getBoundingBox().minY + d1 + 0.5;
                double z = this.getZ() + d2 * d1;
                this.level().addParticle((ParticleOptions)particle, x, y, z, 0.0, -0.075, 0.0);
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof Snowball) {
            amount += 3.0f;
        }
        return super.hurt(source, amount);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || source.getEntity() != null && source.getEntity().getType() == AetherEntityTypes.SUN_SPIRIT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AetherSoundEvents.ENTITY_FIRE_MINION_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_FIRE_MINION_DEATH.get();
    }
}

