/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat.loot;

import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.combat.AetherItemTiers;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class FlamingSwordItem
extends SwordItem {
    public FlamingSwordItem() {
        super((Tier)AetherItemTiers.FLAMING, new Item.Properties().rarity(AetherItems.AETHER_LOOT).attributes(SwordItem.createAttributes((Tier)AetherItemTiers.FLAMING, (float)3.0f, (float)-2.4f)));
    }

    public static void onLivingDamage(LivingDamageEvent.Post event) {
        LivingEntity target = event.getEntity();
        DamageSource damageSource = event.getSource();
        FlamingSwordItem.handleFlamingSwordAbility(target, damageSource);
    }

    private static void handleFlamingSwordAbility(LivingEntity target, DamageSource source) {
        ItemStack heldStack;
        LivingEntity attacker;
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity && EquipmentUtil.isFullStrength(attacker = (LivingEntity)entity) && (heldStack = attacker.getMainHandItem()).is((Item)AetherItems.FLAMING_SWORD.get())) {
            int defaultTime = 30;
            int fireAspectModifier = EnchantmentHelper.getEnchantmentLevel((Holder)attacker.level().holderOrThrow(Enchantments.FIRE_ASPECT), (LivingEntity)attacker);
            if (fireAspectModifier > 0) {
                defaultTime += fireAspectModifier * 4;
            }
            target.igniteForSeconds((float)defaultTime);
        }
    }
}

