/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat.loot;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.projectile.weapon.ThrownLightningKnife;
import com.aetherteam.aether.item.AetherItems;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class LightningKnifeItem
extends Item
implements ProjectileItem {
    public LightningKnifeItem() {
        super(new Item.Properties().rarity(AetherItems.AETHER_LOOT).stacksTo(16));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            if (!player.getAbilities().instabuild && heldStack.getEnchantmentLevel(level.holderOrThrow(Enchantments.INFINITY)) == 0) {
                heldStack.shrink(1);
            }
            ThrownLightningKnife lightningKnife = new ThrownLightningKnife((LivingEntity)player, level);
            lightningKnife.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.8f, 1.0f);
            level.addFreshEntity((Entity)lightningKnife);
        }
        level.playLocalSound(player.getX(), player.getY(), player.getZ(), (SoundEvent)AetherSoundEvents.ITEM_LIGHTNING_KNIFE_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 0.8f), false);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.success((Object)heldStack);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        ThrownLightningKnife lightningKnife = new ThrownLightningKnife(level);
        lightningKnife.setPos(pos.x(), pos.y(), pos.z());
        return lightningKnife;
    }

    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().uncertainty(1.5f).build();
    }
}

