/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;

@Config(name="fallingleaves")
public class FallingLeavesConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    @ConfigEntry.Category(value="fallingleaves.general")
    public int version = 1;
    @ConfigEntry.Gui.Excluded
    @ConfigEntry.Category(value="fallingleaves.general")
    public boolean displayDebugData = false;
    @ConfigEntry.Category(value="fallingleaves.general")
    public boolean enabled = true;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.BoundedDiscrete(min=1L, max=10L)
    private int leafSize = 5;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=100L, max=600L)
    public int leafLifespan = 200;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(max=20L)
    private int leafSpawnRate = 10;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(max=20L)
    private int coniferLeafSpawnRate = 0;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(max=20L)
    public int cherrySpawnRate = 10;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(max=40L)
    private int snowflakeSpawnRate = 15;
    @ConfigEntry.Category(value="fallingleaves.general")
    public boolean dropFromPlayerPlacedBlocks = true;
    @ConfigEntry.Category(value="fallingleaves.general")
    public boolean leavesOnBlockHit = true;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=1L, max=20L)
    public int minimumFreeSpaceBelow = 1;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    public boolean windEnabled = true;
    @ConfigEntry.Category(value="fallingleaves.general")
    public Set<ResourceLocation> windlessDimensions = new HashSet<ResourceLocation>(Arrays.asList(ResourceLocation.withDefaultNamespace((String)"the_nether"), ResourceLocation.withDefaultNamespace((String)"the_end")));
    @ConfigEntry.Category(value="fallingleaves.leafsettings")
    @ConfigEntry.Gui.TransitiveObject
    public Map<ResourceLocation, LeafSettingsEntry> leafSettings = new HashMap<ResourceLocation, LeafSettingsEntry>();
    @ConfigEntry.Category(value="fallingleaves.experimental")
    @ConfigEntry.Gui.Tooltip(count=2)
    private Set<String> leafSpawners = new HashSet<String>();
    @ConfigEntry.Gui.Excluded
    @ConfigEntry.Category(value="fallingleaves.experimental")
    private transient Set<ResourceLocation> leafSpawnerIds = new HashSet<ResourceLocation>();
    @ConfigEntry.Gui.Excluded
    @ConfigEntry.Category(value="fallingleaves.experimental")
    private transient Map<ResourceLocation, Map<Property<?>, Comparable<?>>> leafSpawnerProperties = new HashMap();
    @ConfigEntry.Category(value="fallingleaves.experimental")
    @ConfigEntry.Gui.Tooltip
    public double fallSpawnRateFactor = 1.8;
    @ConfigEntry.Category(value="fallingleaves.experimental")
    @ConfigEntry.Gui.Tooltip
    public double winterSpawnRateFactor = 0.1;
    @ConfigEntry.Category(value="fallingleaves.experimental")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=0L, max=23L)
    public int startingSpawnRadius = 0;
    @ConfigEntry.Category(value="fallingleaves.experimental")
    @ConfigEntry.Gui.Tooltip
    public double decaySpawnRateFactor = 2.6;
    @ConfigEntry.Category(value="fallingleaves.experimental")
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(min=0L, max=30L)
    public volatile int maxDecayLeaves = 9;
    @ConfigEntry.Category(value="fallingleaves.experimental")
    @ConfigEntry.Gui.Tooltip
    public boolean registerParticles = true;

    public float getLeafSize() {
        return (float)this.leafSize / 50.0f;
    }

    public double getBaseLeafSpawnChance() {
        double actualSpawnRate = (double)this.leafSpawnRate / 10.0;
        return actualSpawnRate / 75.0;
    }

    public double getBaseConiferLeafSpawnChance() {
        double actualSpawnRate = (double)this.coniferLeafSpawnRate / 10.0;
        return actualSpawnRate / 75.0;
    }

    public double getCherrySpawnRateFactor() {
        return (double)this.cherrySpawnRate / 20.0;
    }

    public double getSnowflakeSpawnChance() {
        double actualSpawnRate = (double)this.snowflakeSpawnRate / 10.0;
        return actualSpawnRate / 75.0;
    }

    public boolean isLeafSpawner(ResourceLocation blockId) {
        return this.leafSpawnerIds.contains(blockId);
    }

    public Map<Property<?>, Comparable<?>> getLeafSpawnerProperties(ResourceLocation blockId) {
        return this.leafSpawnerProperties.getOrDefault(blockId, Map.of());
    }

    public void updateLeafSettings(ResourceLocation blockId, Consumer<LeafSettingsEntry> f) {
        this.leafSettings.compute(blockId, (id, entry) -> {
            if (entry == null) {
                entry = new LeafSettingsEntry((ResourceLocation)id);
            }
            f.accept((LeafSettingsEntry)entry);
            return entry;
        });
    }

    public void setLeafSize(double leafSize) {
        this.leafSize = (int)(leafSize * 50.0);
    }

    public void setLeafSpawnRate(double leafRate) {
        this.leafSpawnRate = (int)(leafRate * 10.0);
    }

    public void setConiferLeafSpawnRate(double coniferLeafRate) {
        this.coniferLeafSpawnRate = (int)(coniferLeafRate * 10.0);
    }

    private void parseLeafSpawners() {
        this.leafSpawnerIds.clear();
        this.leafSpawnerProperties.clear();
        for (String spawner : this.leafSpawners) {
            int a = spawner.indexOf("[");
            if (a != -1) {
                ResourceLocation id = ResourceLocation.parse((String)spawner.substring(0, a));
                this.leafSpawnerIds.add(id);
                try {
                    BlockStateParser.BlockResult block = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)spawner, (boolean)false);
                    this.leafSpawnerProperties.put(id, block.properties());
                }
                catch (CommandSyntaxException e) {
                    FallingLeavesClient.LOGGER.error("could not parse block state arguments of {}", (Object)spawner);
                }
                continue;
            }
            this.leafSpawnerIds.add(ResourceLocation.parse((String)spawner));
        }
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        this.version = 1;
        this.leafSize = Math.max(this.leafSize, 1);
        this.minimumFreeSpaceBelow = Math.max(this.minimumFreeSpaceBelow, 1);
        this.parseLeafSpawners();
        for (ResourceLocation spawner : this.leafSpawnerIds) {
            this.leafSettings.computeIfAbsent(spawner, LeafSettingsEntry::new);
        }
    }
}

