/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.config.gui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntSliderBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.ConfigDefaults;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.util.TranslationComparator;

public class LeafSettingsGuiProvider
implements GuiProvider {
    private static final MutableComponent RESET_TEXT = Component.translatable((String)"text.cloth-config.reset_value");

    public static String getModName(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(c -> c.getMetadata().getName()).orElse(modId);
    }

    public List<AbstractConfigListEntry> get(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        try {
            Map leafSettings = (Map)field.get(config);
            ArrayList<AbstractConfigListEntry> entries = new ArrayList<AbstractConfigListEntry>(leafSettings.size());
            leafSettings.entrySet().stream().filter(e -> BuiltInRegistries.BLOCK.containsKey((ResourceLocation)e.getKey())).sorted((e1, e2) -> TranslationComparator.INST.compare(((Block)BuiltInRegistries.BLOCK.get((ResourceLocation)e1.getKey())).getDescriptionId(), ((Block)BuiltInRegistries.BLOCK.get((ResourceLocation)e2.getKey())).getDescriptionId())).forEachOrdered(e -> {
                ResourceLocation blockId = (ResourceLocation)e.getKey();
                LeafSettingsEntry leafEntry = (LeafSettingsEntry)e.getValue();
                Block block = (Block)BuiltInRegistries.BLOCK.get(blockId);
                MutableComponent text = Component.translatable((String)block.getDescriptionId());
                if (!leafEntry.isDefault(blockId)) {
                    text.append("*");
                }
                SubCategoryBuilder builder = new SubCategoryBuilder((Component)RESET_TEXT, (Component)text).setTooltip(new Component[]{Component.nullToEmpty((String)LeafSettingsGuiProvider.getModName(blockId.getNamespace()))});
                builder.add((AbstractConfigListEntry)LeafSettingsGuiProvider.buildSpawnRateFactorSlider(blockId, leafEntry));
                builder.add((AbstractConfigListEntry)LeafSettingsGuiProvider.buildIsConiferLeavesToggle(blockId, leafEntry));
                builder.add((AbstractConfigListEntry)LeafSettingsGuiProvider.buildSpawnBreakingLeaves(blockId, leafEntry));
                entries.add((AbstractConfigListEntry)builder.build());
            });
            return entries;
        }
        catch (IllegalAccessException e3) {
            FallingLeavesClient.LOGGER.error((Object)e3);
            return Collections.emptyList();
        }
    }

    private static IntegerSliderEntry buildSpawnRateFactorSlider(ResourceLocation blockId, LeafSettingsEntry entry) {
        int min = 0;
        int max = 1000;
        int stepSize = 10;
        int currentValue = (int)(entry.spawnRateFactor * 100.0);
        int defaultValue = (int)(ConfigDefaults.spawnRateFactor(blockId) * 100.0);
        return new IntSliderBuilder((Component)RESET_TEXT, (Component)Component.translatable((String)"config.fallingleaves.spawn_rate_factor"), currentValue /= stepSize, min /= stepSize, max /= stepSize).setDefaultValue(defaultValue /= stepSize).setSaveConsumer(value -> {
            entry.spawnRateFactor = (double)(value * stepSize) / 100.0;
        }).setTextGetter(value -> Component.nullToEmpty((String)(value * stepSize + "%"))).setTooltip(new Component[]{Component.translatable((String)"config.fallingleaves.spawn_rate_factor.@Tooltip")}).build();
    }

    private static BooleanListEntry buildIsConiferLeavesToggle(ResourceLocation blockId, LeafSettingsEntry entry) {
        return new BooleanToggleBuilder((Component)RESET_TEXT, (Component)Component.translatable((String)"config.fallingleaves.is_conifer"), entry.isConiferBlock).setDefaultValue(ConfigDefaults.isConifer(blockId)).setSaveConsumer(value -> {
            entry.isConiferBlock = value;
        }).build();
    }

    private static BooleanListEntry buildSpawnBreakingLeaves(ResourceLocation blockId, LeafSettingsEntry entry) {
        return new BooleanToggleBuilder((Component)RESET_TEXT, (Component)Component.translatable((String)"config.fallingleaves.spawn_breaking_leaves"), entry.spawnBreakingLeaves).setDefaultValue(ConfigDefaults.spawnBreakingLeaves(blockId)).setSaveConsumer(value -> {
            entry.spawnBreakingLeaves = value;
        }).build();
    }
}

