/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.init;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.FallingLeavesConfig;
import randommcsomethin.fallingleaves.config.FallingLeavesConfigV0;
import randommcsomethin.fallingleaves.config.gson.GsonConfigHelper;
import randommcsomethin.fallingleaves.config.gson.IdentifierTypeAdapter;
import randommcsomethin.fallingleaves.config.gson.LeafSettingsTypeAdapter;
import randommcsomethin.fallingleaves.config.gui.IdentifierGuiProvider;
import randommcsomethin.fallingleaves.config.gui.LeafSettingsGuiProvider;
import randommcsomethin.fallingleaves.config.gui.StringSetGuiProvider;
import randommcsomethin.fallingleaves.util.Wind;

public class Config {
    public static FallingLeavesConfig CONFIG;
    public static final Gson GSON;
    private static ConfigHolder<FallingLeavesConfig> configHolder;

    public static void init() {
        Config.migrateOldConfig();
        configHolder = AutoConfig.register(FallingLeavesConfig.class, (definition, configClass) -> new GsonConfigSerializer(definition, configClass, GSON));
        CONFIG = (FallingLeavesConfig)configHolder.getConfig();
        configHolder.registerSaveListener((manager, data) -> {
            try {
                data.validatePostLoad();
            }
            catch (ConfigData.ValidationException validationException) {
                // empty catch block
            }
            Wind.init();
            return InteractionResult.SUCCESS;
        });
        if (Config.CONFIG.displayDebugData && FallingLeavesClient.LOGGER.getLevel().compareTo(Level.DEBUG) < 0) {
            Configurator.setLevel((String)FallingLeavesClient.LOGGER.getName(), (Level)Level.DEBUG);
        }
        AutoConfig.getGuiRegistry(FallingLeavesConfig.class).registerPredicateProvider((GuiProvider)new LeafSettingsGuiProvider(), field -> field.getName().equals("leafSettings"));
        for (StringSetGuiProvider<String> guiProvider : List.of(new StringSetGuiProvider<ResourceLocation>(ResourceLocation.class, ResourceLocation::parse), new StringSetGuiProvider<String>(String.class, s -> s))) {
            AutoConfig.getGuiRegistry(FallingLeavesConfig.class).registerPredicateProvider(guiProvider, guiProvider.getPredicate());
        }
        AutoConfig.getGuiRegistry(FallingLeavesConfig.class).registerTypeProvider((GuiProvider)new IdentifierGuiProvider(), new Class[]{ResourceLocation.class});
        FallingLeavesClient.LOGGER.debug("Loaded configuration.");
    }

    public static void save() {
        configHolder.save();
    }

    private static void migrateOldConfig() {
        FallingLeavesConfigV0 oldConfig;
        GsonConfigHelper gsonHelper = new GsonConfigHelper("fallingleaves", GSON);
        if (!gsonHelper.exists()) {
            return;
        }
        try {
            oldConfig = gsonHelper.load(FallingLeavesConfigV0.class);
        }
        catch (JsonParseException | IOException e) {
            FallingLeavesClient.LOGGER.debug("Couldn't load config as v0, assuming it is v1");
            return;
        }
        if (oldConfig.version != 0) {
            return;
        }
        FallingLeavesClient.LOGGER.info("Migrating old v0 config");
        FallingLeavesConfig newConfig = new FallingLeavesConfig();
        newConfig.setLeafSize(oldConfig.leafSize);
        newConfig.leafLifespan = oldConfig.leafLifespan;
        newConfig.setLeafSpawnRate(oldConfig.leafRate);
        newConfig.setConiferLeafSpawnRate(oldConfig.coniferLeafRate);
        for (String string : oldConfig.coniferLeafIds) {
            newConfig.updateLeafSettings(ResourceLocation.parse((String)string), entry -> {
                entry.isConiferBlock = true;
            });
        }
        for (Map.Entry entry2 : oldConfig.rateOverrides.entrySet()) {
            newConfig.updateLeafSettings(ResourceLocation.parse((String)((String)entry2.getKey())), newEntry -> {
                double oldRateOverride = (Double)oldEntry.getValue();
                if (newEntry.isConiferBlock) {
                    if (oldConfig.coniferLeafRate != 0.0) {
                        newEntry.spawnRateFactor = oldRateOverride / oldConfig.coniferLeafRate;
                    }
                } else if (oldConfig.leafRate != 0.0) {
                    newEntry.spawnRateFactor = oldRateOverride / oldConfig.leafRate;
                }
            });
        }
        try {
            gsonHelper.save(newConfig);
            FallingLeavesClient.LOGGER.info("Migrated successfully");
        }
        catch (JsonIOException | IOException e) {
            FallingLeavesClient.LOGGER.error("Couldn't save migrated config!", e);
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(ResourceLocation.class, (Object)IdentifierTypeAdapter.INST).registerTypeAdapterFactory((TypeAdapterFactory)new LeafSettingsTypeAdapter()).create();
    }
}

