/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.init;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.block.state.BlockState;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.particle.FallingLeafParticle;
import randommcsomethin.fallingleaves.util.LeafUtil;
import randommcsomethin.fallingleaves.util.TextureCache;

public class Leaves {
    public static final ParticleType<BlockParticleOption> FALLING_LEAF;
    public static final ParticleType<BlockParticleOption> FALLING_CONIFER_LEAF;
    public static final ParticleType<BlockParticleOption> FALLING_SNOW;
    public static final Map<ParticleType<BlockParticleOption>, ResourceLocation> LEAVES;
    public static final Map<ParticleType<BlockParticleOption>, ParticleProvider<BlockParticleOption>> FACTORIES;
    private static boolean preLoadedRegisteredLeafBlocks;

    public static void init() {
        if (Config.CONFIG.registerParticles) {
            FallingLeavesClient.LOGGER.info("Registering leaf particles.");
            Leaves.registerLeafParticles();
        }
        Leaves.registerReloadListener();
        Leaves.registerAttackBlockLeaves();
    }

    private static void registerLeafParticles() {
        for (Map.Entry<ParticleType<BlockParticleOption>, ResourceLocation> entry : LEAVES.entrySet()) {
            Registry.register((Registry)BuiltInRegistries.PARTICLE_TYPE, (ResourceLocation)entry.getValue(), entry.getKey());
            ParticleFactoryRegistry.getInstance().register(entry.getKey(), FallingLeafParticle.BlockStateFactory::new);
        }
    }

    private static void registerReloadListener() {
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void onResourceManagerReload(ResourceManager resourceManager) {
                if (!preLoadedRegisteredLeafBlocks) {
                    for (Map.Entry<ResourceLocation, LeafSettingsEntry> registered : LeafUtil.getRegisteredLeafBlocks(false).entrySet()) {
                        Config.CONFIG.leafSettings.computeIfAbsent(registered.getKey(), k -> (LeafSettingsEntry)registered.getValue());
                    }
                    preLoadedRegisteredLeafBlocks = true;
                }
                TextureCache.INST.clear();
            }

            public ResourceLocation getFabricId() {
                return FallingLeavesClient.id("resource_reload_listener");
            }
        });
    }

    private static void registerAttackBlockLeaves() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (!(Config.CONFIG.enabled && Config.CONFIG.leavesOnBlockHit && world.isClientSide)) {
                return InteractionResult.PASS;
            }
            BlockState state = world.getBlockState(pos);
            LeafSettingsEntry leafSettings = LeafUtil.getLeafSettingsEntry(state);
            if (leafSettings != null) {
                int i;
                if (leafSettings.spawnBreakingLeaves) {
                    int count = 0;
                    for (i = 0; i < 3; ++i) {
                        if (!world.random.nextBoolean()) continue;
                        ++count;
                    }
                    LeafUtil.spawnLeafParticles(count, false, state, world, pos, world.random, leafSettings);
                }
                if (Config.CONFIG.getSnowflakeSpawnChance() != 0.0) {
                    int snowCount = 0;
                    for (i = 0; i < 6; ++i) {
                        if (!world.random.nextBoolean()) continue;
                        ++snowCount;
                    }
                    LeafUtil.spawnSnowParticles(snowCount, false, state, world, pos, world.random, leafSettings);
                }
            }
            return InteractionResult.PASS;
        });
    }

    static {
        FACTORIES = new IdentityHashMap<ParticleType<BlockParticleOption>, ParticleProvider<BlockParticleOption>>();
        preLoadedRegisteredLeafBlocks = false;
        FALLING_LEAF = FabricParticleTypes.complex((boolean)true, BlockParticleOption::codec, BlockParticleOption::streamCodec);
        FALLING_CONIFER_LEAF = FabricParticleTypes.complex((boolean)true, BlockParticleOption::codec, BlockParticleOption::streamCodec);
        FALLING_SNOW = FabricParticleTypes.complex((boolean)true, BlockParticleOption::codec, BlockParticleOption::streamCodec);
        LEAVES = Map.of(FALLING_LEAF, FallingLeavesClient.id("falling_leaf"), FALLING_CONIFER_LEAF, FallingLeavesClient.id("falling_leaf_conifer"), FALLING_SNOW, FallingLeavesClient.id("falling_snow"));
    }
}

