/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.mixin;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.util.LeafUtil;

@Mixin(value={Block.class})
public abstract class BlockMixin {
    @Inject(method={"randomDisplayTick"}, at={@At(value="HEAD")})
    private void randomLeafBlockTick(BlockState state, Level world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (!Config.CONFIG.enabled) {
            return;
        }
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        if (!Config.CONFIG.isLeafSpawner(id)) {
            return;
        }
        for (Map.Entry<Property<?>, Comparable<?>> entry : Config.CONFIG.getLeafSpawnerProperties(id).entrySet()) {
            Property<?> property = entry.getKey();
            Comparable<?> value = entry.getValue();
            if (!state.hasProperty(property) || state.getValue(property).equals(value)) continue;
            return;
        }
        LeafUtil.trySpawnLeafAndSnowParticle(state, world, pos, random);
    }
}

