/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.util.LeafUtil;

@Environment(value=EnvType.CLIENT)
@Mixin(value={LeavesBlock.class})
public abstract class LeafTickMixin {
    @Inject(method={"randomDisplayTick"}, at={@At(value="HEAD")})
    private void randomLeafBlockTick(BlockState state, Level world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (!Config.CONFIG.enabled) {
            return;
        }
        LeafSettingsEntry leafSettings = LeafUtil.getLeafSettingsEntry(state);
        if (leafSettings == null) {
            return;
        }
        if (!Config.CONFIG.dropFromPlayerPlacedBlocks && ((Boolean)state.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue()) {
            return;
        }
        LeafUtil.trySpawnLeafAndSnowParticle(state, world, pos, random);
    }

    @Inject(method={"randomTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z")})
    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (!Config.CONFIG.enabled || Config.CONFIG.maxDecayLeaves == 0) {
            return;
        }
        Minecraft.getInstance().execute(() -> {
            int i;
            ClientLevel clientWorld = Minecraft.getInstance().level;
            if (clientWorld == null) {
                return;
            }
            LeafSettingsEntry leafSettings = LeafUtil.getLeafSettingsEntry(state);
            if (leafSettings == null) {
                return;
            }
            if (leafSettings.spawnBreakingLeaves) {
                int count = 0;
                for (i = 0; i < Config.CONFIG.maxDecayLeaves; ++i) {
                    if (!clientWorld.random.nextBoolean()) continue;
                    ++count;
                }
                LeafUtil.spawnLeafParticles(count, true, state, (Level)clientWorld, pos, clientWorld.random, leafSettings);
            }
            int snowCount = 0;
            for (i = 0; i < 2 * Config.CONFIG.maxDecayLeaves; ++i) {
                if (!clientWorld.random.nextBoolean()) continue;
                ++snowCount;
            }
            LeafUtil.spawnSnowParticles(snowCount, true, state, (Level)clientWorld, pos, clientWorld.random, leafSettings);
        });
    }
}

