/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.mixin;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.init.Leaves;
import randommcsomethin.fallingleaves.mixin.SimpleSpriteProviderInvoker;
import randommcsomethin.fallingleaves.particle.FallingLeafParticle;
import randommcsomethin.fallingleaves.seasons.Seasons;
import randommcsomethin.fallingleaves.util.Wind;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ParticleEngine.class}, priority=1010)
public abstract class ParticleManagerMixin {
    @Shadow
    protected ClientLevel level;
    @Shadow
    @Final
    private Map<ResourceLocation, ParticleEngine.MutableSpriteSet> spriteSets;
    @Shadow
    @Final
    private Int2ObjectMap<ParticleProvider<?>> providers;

    @Inject(method={"registerDefaultFactories"}, at={@At(value="RETURN")})
    public void registerLeafFactories(CallbackInfo ci) {
        for (Map.Entry<ParticleType<BlockParticleOption>, ResourceLocation> entry : Leaves.LEAVES.entrySet()) {
            ParticleType<BlockParticleOption> type = entry.getKey();
            ResourceLocation id = entry.getValue();
            ParticleProvider particleFactory = (ParticleProvider)this.providers.get(BuiltInRegistries.PARTICLE_TYPE.getId(type));
            if (particleFactory == null) {
                ParticleEngine.MutableSpriteSet spriteProvider = SimpleSpriteProviderInvoker.init();
                this.spriteSets.put(id, spriteProvider);
                particleFactory = new FallingLeafParticle.BlockStateFactory((SpriteSet)spriteProvider);
            }
            Leaves.FACTORIES.put(type, (ParticleProvider<BlockParticleOption>)particleFactory);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (!Config.CONFIG.enabled) {
            return;
        }
        Seasons.tick(this.level);
        Wind.tick(this.level);
    }
}

