/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.particle;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.init.Leaves;
import randommcsomethin.fallingleaves.util.LeafUtil;
import randommcsomethin.fallingleaves.util.Wind;

public class FallingLeafParticle
extends TextureSheetParticle {
    public static final float TAU = (float)Math.PI * 2;
    public static final int FADE_DURATION = 16;
    public static final double WATER_FRICTION = 0.075;
    protected final float windCoefficient;
    protected final float maxRotateSpeed;
    protected final int maxRotateTime;
    protected int rotateTime = 0;
    protected boolean inWater = false;
    protected boolean stuckInGround = false;

    public FallingLeafParticle(ClientLevel clientWorld, double x, double y, double z, double r, double g, double b, SpriteSet provider) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        this.pickSprite(provider);
        this.gravity = 0.08f + this.random.nextFloat() * 0.04f;
        this.windCoefficient = 0.6f + this.random.nextFloat() * 0.4f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.lifetime = Config.CONFIG.leafLifespan;
        this.rCol = (float)r;
        this.gCol = (float)g;
        this.bCol = (float)b;
        this.maxRotateTime = (3 + this.random.nextInt(5)) * 20;
        this.maxRotateSpeed = (float)(this.random.nextBoolean() ? -1 : 1) * (0.1f + 2.4f * this.random.nextFloat()) * ((float)Math.PI * 2) / 20.0f;
        this.roll = this.oRoll = this.random.nextFloat() * ((float)Math.PI * 2);
        this.quadSize = Config.CONFIG.getLeafSize();
    }

    public void tick() {
        double waterY;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.oRoll = this.roll;
        ++this.age;
        if (this.age >= this.lifetime + 1 - 16) {
            this.alpha -= 0.0625f;
        }
        if (this.age >= this.lifetime) {
            this.remove();
            return;
        }
        BlockPos blockPos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        FluidState fluidState = this.level.getFluidState(blockPos);
        if (fluidState.is(FluidTags.LAVA) && (waterY = (double)((float)blockPos.getY() + fluidState.getHeight((BlockGetter)this.level, blockPos))) >= this.y) {
            this.level.addParticle((ParticleOptions)ParticleTypes.LAVA, this.x, this.y, this.z, 0.0, 0.0, 0.0);
            this.remove();
            return;
        }
        this.yd -= 0.04 * (double)this.gravity;
        if (fluidState.is(FluidTags.WATER)) {
            double d;
            waterY = (float)blockPos.getY() + fluidState.getHeight((BlockGetter)this.level, blockPos);
            if (d >= this.y - 0.1) {
                if (!this.inWater) {
                    this.inWater = true;
                    if (Math.abs(waterY - this.y) < 0.2) {
                        this.y = waterY;
                    }
                    this.yd *= 0.1;
                    this.xd *= 0.5;
                    this.zd *= 0.5;
                    this.rotateTime = 0;
                } else {
                    double depth = Math.max(waterY + 0.1 - this.y, 0.0);
                    this.yd += depth * (double)this.windCoefficient / 30.0;
                }
                if (!fluidState.isSource()) {
                    Vec3 pushVel = fluidState.getFlow((BlockGetter)this.level, blockPos).scale(0.4);
                    this.xd += (pushVel.x - this.xd) * (double)this.windCoefficient / 60.0;
                    this.zd += (pushVel.z - this.zd) * (double)this.windCoefficient / 60.0;
                }
                this.xd *= 0.925;
                this.yd *= 0.925;
                this.zd *= 0.925;
            }
        } else {
            this.inWater = false;
            if (!this.onGround) {
                this.rotateTime = Math.min(this.rotateTime + 1, this.maxRotateTime);
                this.roll += (float)this.rotateTime / (float)this.maxRotateTime * this.maxRotateSpeed;
            } else {
                this.rotateTime = 0;
            }
            this.xd += ((double)Wind.windX - this.xd) * (double)this.windCoefficient / 60.0;
            this.zd += ((double)Wind.windZ - this.zd) * (double)this.windCoefficient / 60.0;
        }
        this.move(this.xd, this.yd, this.zd);
    }

    public void move(double dx, double dy, double dz) {
        if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return;
        }
        double oldDx = dx;
        double oldDy = dy;
        double oldDz = dz;
        Vec3 vec3d = Entity.collideBoundingBox(null, (Vec3)new Vec3(dx, dy, dz), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
        dx = vec3d.x;
        dy = vec3d.y;
        dz = vec3d.z;
        if (oldDx != dx) {
            this.xd = 0.0;
        }
        if (oldDz != dz) {
            this.zd = 0.0;
        }
        boolean bl = this.onGround = oldDy != dy && oldDy < 0.0;
        if (!this.onGround) {
            this.stuckInGround = false;
        } else if (!this.stuckInGround && Math.abs(dy) < 1.0E-5) {
            this.stuckInGround = true;
        }
        if (this.stuckInGround) {
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
            return;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(dx, dy, dz));
            this.setLocationFromBoundingbox();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Environment(value=EnvType.CLIENT)
    public record BlockStateFactory(SpriteSet provider) implements ParticleProvider<BlockParticleOption>
    {
        public Particle createParticle(BlockParticleOption parameters, ClientLevel world, double x, double y, double z, double unusedX, double unusedY, double unusedZ) {
            double r;
            double g;
            double b;
            if (parameters.getType() == Leaves.FALLING_SNOW) {
                b = 1.0;
                g = 1.0;
                r = 1.0;
            } else {
                double[] color = LeafUtil.getBlockTextureColor(parameters.getState(), (Level)world, BlockPos.containing((double)x, (double)y, (double)z));
                r = color[0];
                g = color[1];
                b = color[2];
            }
            return new FallingLeafParticle(world, x, y, z, r, g, b, this.provider);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record SimpleFactory(SpriteSet provider) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double r, double g, double b) {
            return new FallingLeafParticle(world, x, y, z, r, g, b, this.provider);
        }
    }
}

