/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.init.Leaves;
import randommcsomethin.fallingleaves.mixin.NativeImageAccessor;
import randommcsomethin.fallingleaves.mixin.SpriteContentsAccessor;
import randommcsomethin.fallingleaves.seasons.Season;
import randommcsomethin.fallingleaves.seasons.Seasons;
import randommcsomethin.fallingleaves.util.TextureCache;

public class LeafUtil {
    private static final RandomSource renderRandom = RandomSource.createNewThreadLocalInstance();

    public static double getModifiedSpawnChance(BlockState state, LeafSettingsEntry leafSettings) {
        double spawnChance = leafSettings.getSpawnChance();
        if (Seasons.currentSeason == Season.FALL) {
            spawnChance *= Config.CONFIG.fallSpawnRateFactor;
        } else if (Seasons.currentSeason == Season.WINTER) {
            spawnChance *= Config.CONFIG.winterSpawnRateFactor;
        }
        if (Config.CONFIG.decaySpawnRateFactor != 1.0 && LeafUtil.isLeafBlock(state.getBlock(), true) && state.isRandomlyTicking()) {
            spawnChance *= Config.CONFIG.decaySpawnRateFactor;
        }
        return spawnChance;
    }

    public static void trySpawnLeafAndSnowParticle(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double snowSpawnChance;
        LeafSettingsEntry leafSettings;
        double spawnChance;
        if (Config.CONFIG.startingSpawnRadius > 0) {
            assert (Minecraft.getInstance().player != null);
            if (LeafUtil.getMaximumDistance((Vec3i)Minecraft.getInstance().player.blockPosition(), (Vec3i)pos) < Config.CONFIG.startingSpawnRadius) {
                return;
            }
        }
        if ((spawnChance = LeafUtil.getModifiedSpawnChance(state, leafSettings = Objects.requireNonNull(LeafUtil.getLeafSettingsEntry(state)))) != 0.0 && random.nextDouble() < spawnChance) {
            LeafUtil.spawnLeafParticles(1, false, state, world, pos, random, leafSettings);
        }
        if ((snowSpawnChance = Config.CONFIG.getSnowflakeSpawnChance()) != 0.0 && random.nextDouble() < snowSpawnChance) {
            LeafUtil.spawnSnowParticles(1, false, state, world, pos, random, leafSettings);
        }
    }

    public static void spawnLeafParticles(int count, boolean spawnInsideBlock, BlockState state, Level world, BlockPos pos, RandomSource random, LeafSettingsEntry leafSettings) {
        if (count == 0) {
            return;
        }
        BlockParticleOption params = new BlockParticleOption(leafSettings.isConiferBlock ? Leaves.FALLING_CONIFER_LEAF : Leaves.FALLING_LEAF, state);
        LeafUtil.spawnParticles(count, params, spawnInsideBlock, state, world, pos, random, leafSettings);
    }

    public static void spawnSnowParticles(int count, boolean spawnInsideBlock, BlockState state, Level world, BlockPos pos, RandomSource random, LeafSettingsEntry leafSettings) {
        boolean isSummer;
        if (count == 0) {
            return;
        }
        boolean snowy = false;
        boolean snowyVillagers = VillagerType.byBiome((Holder)world.getBiome(pos)) == VillagerType.SNOW;
        boolean bl = isSummer = Seasons.currentSeason == Season.SUMMER;
        if (!isSummer && snowyVillagers) {
            snowy = true;
        } else {
            Block topBlock = world.getBlockState(world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, pos).below()).getBlock();
            boolean isSnowLayer = topBlock instanceof SnowLayerBlock;
            if (isSnowLayer || topBlock == Blocks.SNOW_BLOCK || topBlock instanceof PowderSnowBlock) {
                snowy = true;
            }
        }
        if (!snowy) {
            return;
        }
        BlockParticleOption params = new BlockParticleOption(Leaves.FALLING_SNOW, state);
        LeafUtil.spawnParticles(count, params, spawnInsideBlock, state, world, pos, random, leafSettings);
    }

    public static void spawnParticles(int count, BlockParticleOption params, boolean spawnInsideBlock, BlockState state, Level world, BlockPos pos, RandomSource random, LeafSettingsEntry leafSettings) {
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            double y;
            double x = (double)pos.getX() + random.nextDouble();
            double z = (double)pos.getZ() + random.nextDouble();
            if (spawnInsideBlock) {
                y = (double)pos.getY() + random.nextDouble();
            } else {
                y = (double)pos.getY() - (state.canOcclude() ? 0.1 : 0.0);
                if (!LeafUtil.hasRoomForLeafParticle(world, pos, x, y, z)) continue;
            }
            LeafUtil.spawnParticle(params, x, y, z);
        }
    }

    public static void spawnParticle(BlockParticleOption params, double x, double y, double z) {
        Minecraft client = Minecraft.getInstance();
        if (Config.CONFIG.registerParticles) {
            client.particleEngine.createParticle((ParticleOptions)params, x, y, z, 0.0, 0.0, 0.0);
        } else {
            Particle particle = Leaves.FACTORIES.get(params.getType()).createParticle((ParticleOptions)params, client.level, x, y, z, 0.0, 0.0, 0.0);
            client.particleEngine.add(particle);
        }
    }

    public static double[] getBlockTextureColor(BlockState state, Level world, BlockPos pos) {
        boolean shouldColor;
        TextureAtlasSprite sprite;
        Minecraft client = Minecraft.getInstance();
        BakedModel model = client.getBlockRenderer().getBlockModel(state);
        renderRandom.setSeed(state.getSeed(pos));
        List quads = model.getQuads(state, Direction.DOWN, renderRandom);
        if (!quads.isEmpty()) {
            boolean useFirstQuad = true;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            if (id.getNamespace().equals("byg")) {
                useFirstQuad = false;
            }
            BakedQuad quad = (BakedQuad)quads.get(useFirstQuad ? 0 : quads.size() - 1);
            sprite = quad.getSprite();
            shouldColor = quad.isTinted();
        } else {
            sprite = model.getParticleIcon();
            shouldColor = true;
        }
        SpriteContents spriteContents = sprite.contents();
        ResourceLocation spriteId = spriteContents.name();
        NativeImage texture = ((SpriteContentsAccessor)spriteContents).getMipmapLevelsImages()[0];
        int blockColor = shouldColor ? client.getBlockColors().getColor(state, (BlockAndTintGetter)world, pos, 0) : -1;
        return LeafUtil.calculateLeafColor(spriteId, texture, blockColor);
    }

    private static double[] calculateLeafColor(ResourceLocation spriteId, NativeImage texture, int blockColor) {
        double[] textureColor;
        TextureCache.Data cache = TextureCache.INST.get(spriteId);
        if (cache != null) {
            textureColor = cache.getColor();
        } else {
            textureColor = LeafUtil.averageColor(texture);
            TextureCache.INST.put(spriteId, new TextureCache.Data(textureColor));
            FallingLeavesClient.LOGGER.debug("{}: Calculated texture color {} ", (Object)spriteId, (Object)textureColor);
        }
        if (blockColor != -1) {
            textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
            textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
            textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
        }
        return textureColor;
    }

    private static boolean hasRoomForLeafParticle(Level world, BlockPos pos, double x, double y, double z) {
        if (LeafUtil.isLeafBlock(world.getBlockState(pos.below()).getBlock(), true)) {
            return false;
        }
        double y2 = y - (double)Config.CONFIG.minimumFreeSpaceBelow * 0.5;
        AABB collisionBox = new AABB(x - 0.1, y, z - 0.1, x + 0.1, y2, z + 0.1);
        return !world.getBlockCollisions(null, collisionBox).iterator().hasNext();
    }

    public static Map<ResourceLocation, LeafSettingsEntry> getRegisteredLeafBlocks(boolean useBlockTags) {
        return BuiltInRegistries.BLOCK.keySet().stream().filter(entry -> LeafUtil.isLeafBlock((Block)BuiltInRegistries.BLOCK.get(entry), useBlockTags)).collect(Collectors.toMap(Function.identity(), LeafSettingsEntry::new));
    }

    public static boolean isLeafBlock(Block block, boolean useBlockTags) {
        return block instanceof LeavesBlock || useBlockTags && block.defaultBlockState().is(BlockTags.LEAVES);
    }

    @Nullable
    public static LeafSettingsEntry getLeafSettingsEntry(BlockState blockState) {
        return Config.CONFIG.leafSettings.get(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()));
    }

    public static int getMaximumDistance(Vec3i v1, Vec3i v2) {
        int dx = Math.abs(v1.getX() - v2.getX());
        int dy = Math.abs(v1.getY() - v2.getY());
        int dz = Math.abs(v1.getZ() - v2.getZ());
        return Math.max(dx, Math.max(dy, dz));
    }

    public static double[] averageColor(NativeImage image) {
        if (image.format() != NativeImage.Format.RGBA) {
            FallingLeavesClient.LOGGER.error("RGBA image required, was {}", (Object)image.format());
            return new double[]{1.0, 1.0, 1.0};
        }
        NativeImageAccessor imageAcc = (NativeImageAccessor)image;
        long pointer = imageAcc.getPointer();
        if (pointer == 0L) {
            FallingLeavesClient.LOGGER.error("image is not allocated");
            return new double[]{1.0, 1.0, 1.0};
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        int width = image.getWidth();
        int height = image.getHeight();
        for (int i = 0; i < width * height; ++i) {
            int c = MemoryUtil.memGetInt((long)(pointer + 4L * (long)i));
            int cr = c & 0xFF;
            int cg = c >> 8 & 0xFF;
            int cb = c >> 16 & 0xFF;
            int ca = c >> 24 & 0xFF;
            if (ca == 0) continue;
            r += (double)cr;
            g += (double)cg;
            b += (double)cb;
            ++n;
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }
}

