/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.util;

import java.util.Comparator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.locale.Language;
import org.jetbrains.annotations.Nullable;
import randommcsomethin.fallingleaves.FallingLeavesClient;

public class TranslationComparator
implements Comparator<String> {
    public static final TranslationComparator INST = new TranslationComparator();
    private final Map<String, String> translations = new WeakHashMap<String, String>();
    private Language cachedLanguage = null;

    private TranslationComparator() {
    }

    @Nullable
    public String getTranslation(String translationKey) {
        String cachedTranslation;
        Language language = Language.getInstance();
        if (language != this.cachedLanguage) {
            this.translations.clear();
            this.cachedLanguage = language;
        }
        if ((cachedTranslation = this.translations.get(translationKey)) == null && language.has(translationKey)) {
            String translation = language.getOrDefault(translationKey);
            this.translations.put(translationKey, translation);
            return translation;
        }
        return cachedTranslation;
    }

    @Override
    public int compare(String key1, String key2) {
        String t1 = this.getTranslation(key1);
        String t2 = this.getTranslation(key2);
        if (t1 == null || t2 == null) {
            FallingLeavesClient.LOGGER.warn("trying to compare non-translated ids {} -> {} with {} -> {}", (Object)key1, (Object)t1, (Object)key2, (Object)t2);
            return key1.compareTo(key2);
        }
        return t1.compareTo(t2);
    }
}

