/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class GreyButton
extends Button {
    private final Minecraft minecraft = Minecraft.getInstance();
    private float durationHovered = 0.0f;

    public GreyButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Button.CreateNarration createNarration) {
        super(x, y, width, height, message, onPress, createNarration);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        this.durationHovered = this.isHovered || this.isFocused() ? Math.min(this.durationHovered + delta / 2.0f, 1.0f) : Math.max(this.durationHovered - delta / 4.0f, 0.0f);
        float alphaScale = Mth.clampedLerp((float)0.9f, (float)0.5f, (float)this.durationHovered);
        int a = (int)(255.0f * alphaScale);
        int greyColor = a << 24;
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, greyColor);
        int i = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderString(guiGraphics, this.minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }
}

