/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.block.custom;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlockEntities;
import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.block.custom.ChunkCacheBlockEntity;
import com.cerbon.bosses_of_mass_destruction.block.custom.MobWardBlockEntity;
import com.cerbon.bosses_of_mass_destruction.block.custom.TripleBlockPart;
import com.cerbon.bosses_of_mass_destruction.capability.util.BMDCapabilities;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichUtils;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.cerbons_api.api.general.particle.ClientParticleBuilder;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class MobWardBlock
extends BaseEntityBlock {
    public static final MapCodec<MobWardBlock> CODEC = MobWardBlock.simpleCodec(MobWardBlock::new);
    public static final VoxelShape blockShape = MobWardBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape thinBlockShape = MobWardBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final EnumProperty<TripleBlockPart> tripleBlockPart = EnumProperty.create((String)"triple_part", TripleBlockPart.class);

    public MobWardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MobWardBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return MobWardBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)BMDBlockEntities.MOB_WARD.get()), ChunkCacheBlockEntity::tick);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.bosses_of_mass_destruction.mob_ward.tooltip").withStyle(ChatFormatting.DARK_GRAY));
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState newState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos posFrom) {
        TripleBlockPart thisState = (TripleBlockPart)((Object)state.getValue(tripleBlockPart));
        BlockState superState = super.updateShape(state, direction, newState, level, pos, posFrom);
        BlockState air = Blocks.AIR.defaultBlockState();
        boolean otherState = newState.is((Block)this);
        BlockState facingState = otherState ? (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)newState.getValue((Property)HorizontalDirectionalBlock.FACING))) : air;
        return switch (thisState) {
            default -> throw new MatchException(null, null);
            case TripleBlockPart.BOTTOM -> {
                switch (direction) {
                    case UP: {
                        if (otherState && newState.getValue(tripleBlockPart) == TripleBlockPart.MIDDLE) {
                            yield facingState;
                        }
                        yield air;
                    }
                }
                yield superState;
            }
            case TripleBlockPart.MIDDLE -> {
                switch (direction) {
                    case UP: {
                        if (otherState && newState.getValue(tripleBlockPart) == TripleBlockPart.TOP) {
                            yield facingState;
                        }
                        yield air;
                    }
                    case DOWN: {
                        if (otherState && newState.getValue(tripleBlockPart) == TripleBlockPart.BOTTOM) {
                            yield facingState;
                        }
                        yield air;
                    }
                }
                yield superState;
            }
            case TripleBlockPart.TOP -> {
                switch (direction) {
                    case DOWN: {
                        if (otherState && newState.getValue(tripleBlockPart) == TripleBlockPart.MIDDLE) {
                            yield facingState;
                        }
                        yield air;
                    }
                }
                yield superState;
            }
        };
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!level.isClientSide && player.isCreative()) {
            TripleBlockPart part = (TripleBlockPart)((Object)state.getValue(tripleBlockPart));
            if (part == TripleBlockPart.MIDDLE) {
                this.checkBreakPart(pos.below(), level, state, player, TripleBlockPart.BOTTOM);
                this.checkBreakPart(pos.above(), level, state, player, TripleBlockPart.TOP);
            } else if (part == TripleBlockPart.TOP) {
                this.checkBreakPart(pos.below(2), level, state, player, TripleBlockPart.BOTTOM);
                this.checkBreakPart(pos.below(), level, state, player, TripleBlockPart.MIDDLE);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    private void checkBreakPart(BlockPos pos, Level level, BlockState state, Player player, TripleBlockPart part) {
        BlockState blockState = level.getBlockState(pos);
        if (blockState.getBlock() == state.getBlock() && blockState.getValue(tripleBlockPart) == part) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, pos, MobWardBlock.getId((BlockState)blockState));
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        if (blockPos.getY() < ctx.getLevel().getMaxBuildHeight() - 2 && ctx.getLevel().getBlockState(blockPos.above()).canBeReplaced(ctx) && ctx.getLevel().getBlockState(blockPos.above(2)).canBeReplaced(ctx)) {
            return (BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DoorBlock.FACING, (Comparable)ctx.getHorizontalDirection())).setValue(tripleBlockPart, (Comparable)((Object)TripleBlockPart.BOTTOM));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(tripleBlockPart, (Comparable)((Object)TripleBlockPart.MIDDLE)), 3);
        level.setBlock(pos.above(2), (BlockState)state.setValue(tripleBlockPart, (Comparable)((Object)TripleBlockPart.TOP)), 3);
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = level.getBlockState(blockPos);
        if (state.getValue(tripleBlockPart) == TripleBlockPart.BOTTOM) {
            return blockState.isFaceSturdy((BlockGetter)level, blockPos, Direction.UP);
        }
        return blockState.is((Block)this);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        return mirror == Mirror.NONE ? state : state.rotate(mirror.getRotation((Direction)state.getValue((Property)DoorBlock.FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, tripleBlockPart});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return state.getValue(tripleBlockPart) == TripleBlockPart.TOP ? blockShape : thinBlockShape;
    }

    public void animateTick(BlockState state, @NotNull Level lvel, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (state.getValue(tripleBlockPart) == TripleBlockPart.TOP && random.nextInt(3) == 0) {
            Vec3 vecPos = VecUtils.asVec3((BlockPos)pos).add(VecUtils.unit.scale(0.5));
            double randomHeight = RandomUtils.randDouble((double)0.25) + 0.25;
            double randomRadius = RandomUtils.randDouble((double)0.1) + 0.3;
            double randomOffset = RandomUtils.randDouble((double)Math.PI);
            Particles.blueFireParticleFactory.continuousPosition(simpleParticle -> this.calcParticlePos(vecPos, randomOffset, randomRadius, randomHeight, (double)simpleParticle.getAge() * 0.1)).build(this.calcParticlePos(vecPos, randomOffset, randomRadius, randomHeight, 0.0), Vec3.ZERO);
        }
    }

    private Vec3 calcParticlePos(Vec3 vecPos, double randomOffset, double randomRadius, double randomHeight, double age) {
        return vecPos.add(new Vec3(Math.sin(age + randomOffset) * randomRadius, randomHeight + age * 0.3, Math.cos(age + randomOffset) * randomRadius));
    }

    public static void canSpawn(ServerLevel serverLevel, BlockPos.MutableBlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos((BlockPos)pos);
        BMDCapabilities.getChunkBlockCache((Level)serverLevel).ifPresent(capability -> {
            for (int x = chunkPos.x - 4; x <= chunkPos.x + 4; ++x) {
                block1: for (int z = chunkPos.z - 4; z <= chunkPos.z + 4; ++z) {
                    List<BlockPos> blocks = capability.getBlocksFromChunk(new ChunkPos(x, z), (Block)BMDBlocks.MOB_WARD.get());
                    if (blocks == null) {
                        return;
                    }
                    for (BlockPos blockPos : blocks) {
                        if (Math.abs(blockPos.getX() - pos.getX()) >= 64 || Math.abs(blockPos.getY() - pos.getY()) >= 64 || Math.abs(blockPos.getZ() - pos.getZ()) >= 64) continue;
                        cir.setReturnValue((Object)false);
                        continue block1;
                    }
                }
            }
        });
    }

    private static class Particles {
        private static final ClientParticleBuilder blueFireParticleFactory = new ClientParticleBuilder((ParticleOptions)BMDParticles.SOUL_FLAME.get()).color(LichUtils.blueColorFade).age(30, 40).colorVariation(0.5).scale(f -> Float.valueOf(0.15f - f.floatValue() * 0.1f));

        private Particles() {
        }
    }
}

