/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet;

import com.cerbon.bosses_of_mass_destruction.config.mob.GauntletConfig;
import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.PunchAction;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.MobUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SwirlPunchAction
implements IActionWithCooldown {
    private final GauntletEntity entity;
    private final EventScheduler eventScheduler;
    private final GauntletConfig mobConfig;
    private final Supplier<Boolean> cancelAction;
    private final ServerLevel serverLevel;
    private double previousSpeed = 0.0;

    public SwirlPunchAction(GauntletEntity entity, EventScheduler eventScheduler, GauntletConfig mobConfig, Supplier<Boolean> cancelAction, ServerLevel serverLevel) {
        this.entity = entity;
        this.eventScheduler = eventScheduler;
        this.mobConfig = mobConfig;
        this.cancelAction = cancelAction;
        this.serverLevel = serverLevel;
    }

    @Override
    public int perform() {
        LivingEntity target = this.entity.getTarget();
        if (target == null) {
            return 40;
        }
        Vec3 targetDirection = MathUtils.unNormedDirection((Vec3)MobUtils.eyePos((Entity)this.entity), (Vec3)target.getBoundingBox().getCenter());
        Vec3 targetPos = MobUtils.eyePos((Entity)this.entity).add(targetDirection.scale(1.2));
        int accelerateStartTime = 30;
        int unclenchTime = 60;
        int closeFistAnimationTime = 7;
        this.entity.push(0.0, 0.7, 0.0);
        SoundUtils.playSound((ServerLevel)this.serverLevel, (Vec3)this.entity.position(), (SoundEvent)((SoundEvent)BMDSounds.GAUNTLET_SPIN_PUNCH.get()), (SoundSource)SoundSource.HOSTILE, (float)2.0f, (float)1.0f, (double)64.0, null);
        this.entity.getEntityData().set(GauntletEntity.isEnergized, (Object)true);
        this.eventScheduler.addEvent((IEvent)new TimedEvent(this.entity.hitboxHelper::setClosedFistHitbox, closeFistAnimationTime, 1, this.cancelAction));
        AtomicReference<Double> velocityStack = new AtomicReference<Double>(0.6);
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
            PunchAction.accelerateTowardsTarget((Entity)this.entity, targetPos, (Double)velocityStack.get());
            velocityStack.set(0.4);
        }, accelerateStartTime, 15, () -> this.entity.position().distanceToSqr(targetPos) < 9.0 || this.cancelAction.get() != false));
        this.eventScheduler.addEvent((IEvent)new TimedEvent(this::whilePunchActive, accelerateStartTime, unclenchTime - accelerateStartTime, this.cancelAction));
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
            this.entity.hitboxHelper.setOpenHandHitbox();
            this.entity.getEntityData().set(GauntletEntity.isEnergized, (Object)false);
        }, unclenchTime));
        return 80;
    }

    private void whilePunchActive() {
        this.testBlockPhysicalImpact();
        this.testEntityImpact();
        this.previousSpeed = this.entity.getDeltaMovement().length();
    }

    private void testBlockPhysicalImpact() {
        if ((this.entity.horizontalCollision || this.entity.verticalCollision) && this.previousSpeed > (double)0.55f) {
            Vec3 pos = this.entity.position();
            if (((Boolean)this.entity.getEntityData().get(GauntletEntity.isEnergized)).booleanValue()) {
                this.entity.level().explode((Entity)this.entity, pos.x, pos.y, pos.z, (float)this.mobConfig.energizedPunchExplosionSize, true, Level.ExplosionInteraction.MOB);
                this.entity.getEntityData().set(GauntletEntity.isEnergized, (Object)false);
            } else {
                this.entity.level().explode((Entity)this.entity, pos.x, pos.y, pos.z, (float)(this.previousSpeed * this.mobConfig.normalPunchExplosionMultiplier), Level.ExplosionInteraction.MOB);
            }
        }
    }

    private void testEntityImpact() {
        List collidedEntities = this.entity.level().getEntitiesOfClass(LivingEntity.class, this.entity.getBoundingBox(), livingEntity -> livingEntity != this.entity);
        for (LivingEntity target : collidedEntities) {
            this.entity.doHurtTarget((Entity)target);
            target.addDeltaMovement(this.entity.getDeltaMovement().scale(0.5));
        }
    }
}

