/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom;

import com.cerbon.bosses_of_mass_destruction.client.render.IRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomClientSpikeHandler;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomEntity;
import com.cerbon.bosses_of_mass_destruction.util.VanillaCopies;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class VoidBlossomSpikeRenderer
implements IRenderer<VoidBlossomEntity> {
    private final ResourceLocation spikeTexture = ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/void_blossom_spike.png");
    private final RenderType type = RenderType.entityCutoutNoCull((ResourceLocation)this.spikeTexture);

    @Override
    public void render(VoidBlossomEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        for (Map.Entry<BlockPos, VoidBlossomClientSpikeHandler.Spike> kv : entity.clientSpikeHandler.getSpikes().entrySet()) {
            this.renderBeam((LivingEntity)entity, kv.getValue(), partialTicks, poseStack, buffer, this.type);
        }
    }

    private void renderBeam(LivingEntity actor, VoidBlossomClientSpikeHandler.Spike spike, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, RenderType type) {
        float numTextures = 8.0f;
        float lifeRatio = 2.0f;
        float textureProgress = Math.max(0.0f, ((float)spike.age() + tickDelta) * lifeRatio / (float)spike.maxAge() - lifeRatio + 1.0f);
        if (textureProgress >= 1.0f) {
            return;
        }
        float spikeHeight = spike.height();
        float textureRatio = 0.34375f;
        float spikeWidth = textureRatio * spikeHeight * 0.5f;
        double upProgress = (Math.sin(Math.min((double)((float)spike.age() + tickDelta) / ((double)spike.maxAge() * 0.4), 1.0) * Math.PI * 0.5) - 1.0) * (double)spikeHeight;
        Function<Float, Float> texTransformer = this.textureMultiplier(Float.valueOf(1.0f / numTextures), (float)(Math.floor(textureProgress * numTextures) / (double)numTextures));
        poseStack.pushPose();
        Vec3 offset = VanillaCopies.fromLerpedPosition(actor, 0.0, tickDelta).subtract(spike.pos());
        poseStack.translate(-offset.x, upProgress - offset.y, -offset.z);
        Vec3 bottomPos = spike.offset();
        float n = (float)Math.acos(bottomPos.y);
        float o = (float)Math.atan2(bottomPos.z, bottomPos.x);
        poseStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - o) * 57.295776f));
        poseStack.mulPose(Axis.XP.rotationDegrees(n * 57.295776f));
        float q = 0.0f;
        int red = (int)(Vec3Colors.WHITE.x * 255.0);
        int green = (int)(Vec3Colors.WHITE.y * 255.0);
        int blue = (int)(Vec3Colors.WHITE.z * 255.0);
        float af = Mth.cos((float)(q + (float)Math.PI)) * spikeWidth;
        float ag = Mth.sin((float)(q + (float)Math.PI)) * spikeWidth;
        float ah = Mth.cos((float)(q + 0.0f)) * spikeWidth;
        float ai = Mth.sin((float)(q + 0.0f)) * spikeWidth;
        float aj = Mth.cos((float)(q + 1.5707964f)) * spikeWidth;
        float ak = Mth.sin((float)(q + 1.5707964f)) * spikeWidth;
        float al = Mth.cos((float)(q + 4.712389f)) * spikeWidth;
        float am = Mth.sin((float)(q + 4.712389f)) * spikeWidth;
        VertexConsumer vertexConsumer = bufferSource.getBuffer(type);
        PoseStack.Pose entry = poseStack.last();
        Matrix4f matrix4f = entry.pose();
        float c0 = texTransformer.apply(Float.valueOf(0.4999f)).floatValue();
        float c2 = texTransformer.apply(Float.valueOf(0.0f)).floatValue();
        float c1 = texTransformer.apply(Float.valueOf(1.0f)).floatValue();
        VanillaCopies.vertex(vertexConsumer, matrix4f, entry, af, spikeHeight, ag, red, green, blue, c0, 0.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, entry, af, 0.0f, ag, red, green, blue, c0, 1.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, entry, ah, 0.0f, ai, red, green, blue, c2, 1.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, entry, ah, spikeHeight, ai, red, green, blue, c2, 0.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, entry, aj, spikeHeight, ak, red, green, blue, c1, 0.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, entry, aj, 0.0f, ak, red, green, blue, c1, 1.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, entry, al, 0.0f, am, red, green, blue, c0, 1.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, entry, al, spikeHeight, am, red, green, blue, c0, 0.0f);
        poseStack.popPose();
    }

    public Function<Float, Float> textureMultiplier(Float multiplier, float adjustment) {
        return texCoord -> Float.valueOf(texCoord.floatValue() * multiplier.floatValue() + adjustment);
    }
}

