/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern;

import com.cerbon.bosses_of_mass_destruction.structure.util.IStructurePiece;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.ICaveDecorator;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;

public class SpikeCaveDecorator
implements ICaveDecorator {
    private final int bottomOfWorld;
    private final RandomSource random;
    private final List<BlockPos> spikePositions = new ArrayList<BlockPos>();
    private final List<Vec3> baseBlocks = MathUtils.buildBlockCircle((double)4.2);

    public SpikeCaveDecorator(int bottomOfWorld, RandomSource random) {
        this.bottomOfWorld = bottomOfWorld;
        this.random = random;
    }

    @Override
    public void onBlockPlaced(BlockPos pos, Block block) {
        double spikeSpacing = Math.pow((double)this.random.nextInt(20) + 10.0, 2.0);
        if (pos.getY() == 5 + this.bottomOfWorld && block != Blocks.AIR && this.spikePositions.stream().allMatch(it -> it.distSqr((Vec3i)pos) > spikeSpacing)) {
            this.spikePositions.add(pos);
        }
    }

    @Override
    public void generate(WorldGenLevel level, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, BlockPos pos, IStructurePiece structurePiece) {
        Map<Pair, List<BlockPos>> groupedSpikePositions = this.spikePositions.stream().collect(Collectors.groupingBy(p -> new Pair((Object)(p.getX() >> 2), (Object)(p.getZ() >> 2))));
        List<BlockPos> spacesSpikePositions = groupedSpikePositions.values().stream().map(list -> (BlockPos)list.get(0)).toList();
        for (BlockPos outerPos : spacesSpikePositions) {
            Vec3 centerDirection = VecUtils.planeProject((Vec3)VecUtils.asVec3((BlockPos)pos.subtract((Vec3i)outerPos)), (Vec3)VecUtils.yAxis).normalize();
            Vec3 tip = centerDirection.scale((double)(5 + random.nextInt(3))).add(VecUtils.yAxis.scale((double)(7 + random.nextInt(5))));
            this.generateSpike(outerPos, outerPos.offset((Vec3i)BlockPos.containing((Position)tip)), structurePiece, level, boundingBox, centerDirection);
        }
    }

    private void generateSpike(BlockPos origin, BlockPos tip, IStructurePiece structurePiece, WorldGenLevel level, BoundingBox boundingBox, Vec3 centerDirection) {
        List blocksInLine;
        Vec3 centerDirectionPos = centerDirection.scale(3.0);
        Set blockSet = this.baseBlocks.stream().map(BlockPos::containing).collect(Collectors.toSet());
        Set innerBlockSet = blockSet.stream().filter(pos -> pos.distToCenterSqr((Position)centerDirectionPos) < Math.pow(2.0, 2.0)).collect(Collectors.toSet());
        Set middleBlockSet = blockSet.stream().filter(block -> !innerBlockSet.contains(block)).filter(block -> block.distToCenterSqr((Position)centerDirectionPos) < Math.pow(3.7, 2.0)).collect(Collectors.toSet());
        Set outerBlockSet = blockSet.stream().filter(pos -> !middleBlockSet.contains(pos) && !innerBlockSet.contains(pos)).collect(Collectors.toSet());
        for (BlockPos blockPos : innerBlockSet) {
            blocksInLine = MathUtils.getBlocksInLine((BlockPos)blockPos.offset((Vec3i)origin), (BlockPos)tip);
            for (BlockPos pos2 : blocksInLine) {
                BlockState blockState = this.random.nextInt(16) == 0 ? Blocks.BUDDING_AMETHYST.defaultBlockState() : Blocks.AMETHYST_BLOCK.defaultBlockState();
                structurePiece.placeBlock(level, blockState, pos2, boundingBox);
            }
        }
        for (BlockPos blockPos : middleBlockSet) {
            blocksInLine = MathUtils.getBlocksInLine((BlockPos)blockPos.offset((Vec3i)origin), (BlockPos)tip);
            for (BlockPos pos2 : blocksInLine) {
                structurePiece.placeBlock(level, Blocks.CALCITE.defaultBlockState(), pos2, boundingBox);
            }
        }
        for (BlockPos blockPos : outerBlockSet) {
            blocksInLine = MathUtils.getBlocksInLine((BlockPos)blockPos.offset((Vec3i)origin), (BlockPos)tip);
            for (BlockPos pos2 : blocksInLine) {
                structurePiece.placeBlock(level, Blocks.SMOOTH_BASALT.defaultBlockState(), pos2, boundingBox);
            }
        }
    }
}

