/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.skins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.bluecolored.bluemap.api.plugin.SkinProvider;
import de.bluecolored.bluemap.core.logger.Logger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;

public class MojangSkinProvider
implements SkinProvider {
    @Override
    public Optional<BufferedImage> load(UUID playerUUID) throws IOException {
        Optional<BufferedImage> optional;
        block8: {
            Reader reader = this.requestProfileJson(playerUUID);
            try {
                JsonParser parser = new JsonParser();
                String textureInfoJson = this.readTextureInfoJson(parser.parse(reader));
                String textureUrl = this.readTextureUrl(parser.parse(textureInfoJson));
                optional = Optional.of(ImageIO.read(new URL(textureUrl)));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    Logger.global.logDebug("Failed to load skin from mojang for player: '" + String.valueOf(playerUUID) + "' - " + String.valueOf(ex));
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }

    private Reader requestProfileJson(UUID playerUUID) throws IOException {
        URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(playerUUID));
        return new InputStreamReader(url.openStream());
    }

    private String readTextureInfoJson(JsonElement json) throws IOException {
        try {
            JsonArray properties = json.getAsJsonObject().getAsJsonArray("properties");
            for (JsonElement element : properties) {
                if (!element.getAsJsonObject().get("name").getAsString().equals("textures")) continue;
                return new String(Base64.getDecoder().decode(element.getAsJsonObject().get("value").getAsString().getBytes()));
            }
            throw new IOException("No texture info found!");
        }
        catch (ClassCastException | IllegalStateException | NullPointerException e) {
            throw new IOException(e);
        }
    }

    private String readTextureUrl(JsonElement json) throws IOException {
        try {
            return json.getAsJsonObject().getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
        }
        catch (ClassCastException | IllegalStateException | NullPointerException e) {
            throw new IOException(e);
        }
    }
}

