/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.text;

import de.bluecolored.bluemap.common.plugin.text.TextColor;
import de.bluecolored.bluemap.common.plugin.text.TextFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Text {
    private String content = "";
    private TextColor color;
    private Set<TextFormat> formats = new HashSet<TextFormat>();
    private Text hoverText;
    private ClickAction clickAction;
    private String clickActionValue;
    private List<Text> children = new ArrayList<Text>();

    public Text setHoverText(Text hoverText) {
        this.hoverText = hoverText;
        return this;
    }

    public Text setClickAction(ClickAction action, String value) {
        this.clickAction = action;
        this.clickActionValue = value;
        return this;
    }

    public Text addChild(Text child) {
        this.children.add(child);
        return this;
    }

    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.quote("text")).append(":").append(this.quote(this.content)).append(',');
        if (this.color != null) {
            sb.append(this.quote("color")).append(":").append(this.quote(this.color.getId())).append(',');
        }
        for (TextFormat format : this.formats) {
            sb.append(this.quote(format.getId())).append(":").append(true).append(',');
        }
        if (this.hoverText != null) {
            sb.append(this.quote("hoverEvent")).append(":{");
            sb.append(this.quote("action")).append(":").append(this.quote("show_text")).append(',');
            sb.append(this.quote("value")).append(":").append(this.quote(this.hoverText.toFormattingCodedString('\u00a7')));
            sb.append("},");
        }
        if (this.clickAction != null && this.clickActionValue != null) {
            sb.append(this.quote("clickEvent")).append(":{");
            sb.append(this.quote("action")).append(":").append(this.quote(this.clickAction.getActionId())).append(',');
            sb.append(this.quote("value")).append(":").append(this.quote(this.clickActionValue));
            sb.append("},");
        }
        if (!this.children.isEmpty()) {
            sb.append(this.quote("extra")).append(":[");
            for (Text child : this.children) {
                sb.append(child.toJSONString()).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("],");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public String toFormattingCodedString(char escapeChar) {
        StringBuilder sb = new StringBuilder();
        if (!this.content.isEmpty()) {
            if (this.color != null) {
                sb.append(escapeChar).append(this.color.getFormattingCode());
            }
            for (TextFormat format : this.formats) {
                sb.append(escapeChar).append(format.getFormattingCode());
            }
            sb.append(this.content);
        }
        for (Text child : this.children) {
            if (sb.length() > 0) {
                sb.append(escapeChar).append('r');
            }
            sb.append(child.withParentFormat(this).toFormattingCodedString(escapeChar));
        }
        return sb.toString();
    }

    public String toPlainString() {
        StringBuilder sb = new StringBuilder();
        if (this.content != null) {
            sb.append(this.content);
        }
        for (Text child : this.children) {
            sb.append(child.toPlainString());
        }
        return sb.toString();
    }

    private Text withParentFormat(Text parent) {
        Text text = new Text();
        text.content = this.content;
        text.clickAction = this.clickAction;
        text.clickActionValue = this.clickActionValue;
        text.hoverText = this.hoverText;
        text.children = this.children;
        text.color = this.color != null ? this.color : parent.color;
        text.formats.addAll(this.formats);
        text.formats.addAll(parent.formats);
        return text;
    }

    private String quote(String value) {
        return "\"" + this.escape(value) + "\"";
    }

    private String escape(String value) {
        value = value.replace("\\", "\\\\");
        value = value.replace("\"", "\\\"");
        value = value.replace("\u00a7", "\\u00a7");
        value = value.replace("\n", "\\n");
        return value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.toJSONString();
    }

    public static Text of(String message) {
        Text text = new Text();
        text.content = message;
        return text;
    }

    public static Text of(TextColor color, String message) {
        Text text = new Text();
        text.content = message;
        text.color = color;
        return text;
    }

    public static Text of(Object ... objects) {
        Text text = new Text();
        Text currentChild = new Text();
        for (Object object : objects) {
            if (object instanceof Text) {
                if (!currentChild.content.isEmpty()) {
                    text.addChild(currentChild);
                    currentChild = new Text().withParentFormat(currentChild);
                }
                text.addChild((Text)object);
                continue;
            }
            if (object instanceof TextColor) {
                if (!currentChild.content.isEmpty()) {
                    text.addChild(currentChild);
                    currentChild = new Text();
                }
                currentChild.color = (TextColor)((Object)object);
                continue;
            }
            if (object instanceof TextFormat) {
                if (!currentChild.content.isEmpty()) {
                    text.addChild(currentChild);
                    currentChild = new Text().withParentFormat(currentChild);
                }
                currentChild.formats.add((TextFormat)((Object)object));
                continue;
            }
            currentChild.content = currentChild.content + object.toString();
        }
        if (!currentChild.content.isEmpty()) {
            text.addChild(currentChild);
        }
        if (text.children.isEmpty()) {
            return text;
        }
        if (text.children.size() == 1) {
            return text.children.get(0);
        }
        return text;
    }

    public static enum ClickAction {
        OPEN_URL("open_url"),
        RUN_COMMAND("run_command"),
        SUGGEST_COMMAND("suggest_command"),
        COPY_TO_CLIPBOARD("copy_to_clipboard");

        private final String action;

        private ClickAction(String action) {
            this.action = action;
        }

        public String getActionId() {
            return this.action;
        }
    }
}

