/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.entitystate;

import com.flowpowered.math.vector.Vector3f;
import com.google.gson.Gson;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import de.bluecolored.bluemap.core.map.hires.entity.EntityRendererType;
import de.bluecolored.bluemap.core.resources.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Model;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public class Part {
    private EntityRendererType renderer = EntityRendererType.DEFAULT;
    private ResourcePath<Model> model = ResourcePack.MISSING_ENTITY_MODEL;
    private Vector3f position = Vector3f.ZERO;
    private Vector3f rotation = Vector3f.ZERO;
    private transient boolean transformed;
    private transient MatrixM4f transformMatrix;

    private Part() {
    }

    private void init() {
        this.transformed = !this.position.equals((Object)Vector3f.ZERO) || !this.rotation.equals((Object)Vector3f.ZERO);
        this.transformMatrix = new MatrixM4f().rotate(this.rotation.getX(), this.rotation.getY(), this.rotation.getZ()).translate(this.position.getX(), this.position.getY(), this.position.getZ());
    }

    public EntityRendererType getRenderer() {
        return this.renderer;
    }

    public ResourcePath<Model> getModel() {
        return this.model;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public MatrixM4f getTransformMatrix() {
        return this.transformMatrix;
    }

    static class Adapter
    extends AbstractTypeAdapterFactory<Part> {
        public Adapter() {
            super(Part.class);
        }

        @Override
        public Part read(JsonReader in, Gson gson) throws IOException {
            Part part = (Part)gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Part.class)).read(in);
            part.init();
            return part;
        }
    }
}

