/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.model;

import com.flowpowered.math.vector.Vector4f;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.TextureVariable;
import de.bluecolored.bluemap.core.util.Direction;
import java.util.function.Function;

public class Face {
    private static final TextureVariable DEFAULT_TEXTURE = new TextureVariable(ResourcePack.MISSING_TEXTURE);
    private Vector4f uv;
    private TextureVariable texture = DEFAULT_TEXTURE;
    private Direction cullface;
    private int rotation = 0;
    private int tintindex = -1;

    private Face() {
    }

    private Face(Face copyFrom) {
        this.uv = copyFrom.uv;
        this.texture = copyFrom.texture.copy();
        this.cullface = copyFrom.cullface;
        this.rotation = copyFrom.rotation;
        this.tintindex = copyFrom.tintindex;
    }

    void init(Direction direction, Function<Direction, Vector4f> defaultUvCalculator, Function<Direction, Direction> defaultCullfaceCalculator) {
        if (this.cullface == null) {
            this.cullface = defaultCullfaceCalculator.apply(direction);
        }
        if (this.uv == null) {
            this.uv = defaultUvCalculator.apply(direction);
        }
    }

    public Face copy() {
        return new Face(this);
    }

    public void optimize(ResourcePack resourcePack) {
        this.texture.optimize(resourcePack);
    }

    public Vector4f getUv() {
        return this.uv;
    }

    public TextureVariable getTexture() {
        return this.texture;
    }

    public Direction getCullface() {
        return this.cullface;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getTintindex() {
        return this.tintindex;
    }
}

