/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql.commandset;

import de.bluecolored.bluemap.core.storage.sql.Database;
import de.bluecolored.bluemap.core.storage.sql.commandset.AbstractCommandSet;
import org.intellij.lang.annotations.Language;

public class PostgreSQLCommandSet
extends AbstractCommandSet {
    public PostgreSQLCommandSet(Database db) {
        super(db);
    }

    @Override
    @Language(value="postgresql")
    public String createMapTableStatement() {
        return "CREATE TABLE IF NOT EXISTS bluemap_map (\n id SMALLSERIAL PRIMARY KEY,\n map_id VARCHAR(190) UNIQUE NOT NULL\n)\n";
    }

    @Override
    @Language(value="postgresql")
    public String createCompressionTableStatement() {
        return "CREATE TABLE IF NOT EXISTS bluemap_compression (\n id SMALLSERIAL PRIMARY KEY,\n key VARCHAR(190) UNIQUE NOT NULL\n)\n";
    }

    @Override
    @Language(value="postgresql")
    public String createItemStorageTableStatement() {
        return "CREATE TABLE IF NOT EXISTS bluemap_item_storage (\n id SERIAL PRIMARY KEY,\n key VARCHAR(190) UNIQUE NOT NULL\n)\n";
    }

    @Override
    @Language(value="postgresql")
    public String createItemStorageDataTableStatement() {
        return "CREATE TABLE IF NOT EXISTS bluemap_item_storage_data (\n map SMALLINT NOT NULL\n  REFERENCES bluemap_map (id)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n storage INT NOT NULL\n  REFERENCES bluemap_item_storage (id)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n compression SMALLINT NOT NULL\n  REFERENCES bluemap_compression (id)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n data BYTEA NOT NULL,\n PRIMARY KEY (map, storage)\n)\n";
    }

    @Override
    @Language(value="postgresql")
    public String createGridStorageTableStatement() {
        return "CREATE TABLE IF NOT EXISTS bluemap_grid_storage (\n id SMALLSERIAL PRIMARY KEY,\n key VARCHAR(190) UNIQUE NOT NULL\n)\n";
    }

    @Override
    @Language(value="postgresql")
    public String createGridStorageDataTableStatement() {
        return "CREATE TABLE IF NOT EXISTS bluemap_grid_storage_data (\n map SMALLINT NOT NULL\n  REFERENCES bluemap_map (id)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n storage SMALLINT NOT NULL\n  REFERENCES bluemap_grid_storage (id)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n x INT NOT NULL,\n z INT NOT NULL,\n compression SMALLINT NOT NULL\n  REFERENCES bluemap_compression (id)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n data BYTEA NOT NULL,\n PRIMARY KEY (map, storage, x, z)\n)\n";
    }

    @Override
    @Language(value="postgresql")
    public String itemStorageWriteStatement() {
        return "INSERT\nINTO bluemap_item_storage_data (map, storage, compression, data)\nVALUES (?, ?, ?, ?)\nON CONFLICT (map, storage)\n DO UPDATE SET\n  compression = excluded.compression,\n  data = excluded.data\n";
    }

    @Override
    @Language(value="postgresql")
    public String itemStorageReadStatement() {
        return "SELECT data\nFROM bluemap_item_storage_data\nWHERE map = ?\nAND storage = ?\nAND compression = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String itemStorageDeleteStatement() {
        return "DELETE\nFROM bluemap_item_storage_data\nWHERE map = ?\nAND storage = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String itemStorageHasStatement() {
        return "SELECT COUNT(*) > 0\nFROM bluemap_item_storage_data\nWHERE map = ?\nAND storage = ?\nAND compression = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String gridStorageWriteStatement() {
        return "INSERT\nINTO bluemap_grid_storage_data (map, storage, x, z, compression, data)\nVALUES (?, ?, ?, ?, ?, ?)\nON CONFLICT (map, storage, x, z)\n DO UPDATE SET\n  compression = excluded.compression,\n  data = excluded.data\n";
    }

    @Override
    @Language(value="postgresql")
    public String gridStorageReadStatement() {
        return "SELECT data\nFROM bluemap_grid_storage_data\nWHERE map = ?\nAND storage = ?\nAND x = ?\nAND z = ?\nAND compression = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String gridStorageDeleteStatement() {
        return "DELETE\nFROM bluemap_grid_storage_data\nWHERE map = ?\nAND storage = ?\nAND x = ?\nAND z = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String gridStorageHasStatement() {
        return "SELECT COUNT(*) > 0\nFROM bluemap_grid_storage_data\nWHERE map = ?\nAND storage = ?\nAND x = ?\nAND z = ?\nAND compression = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String gridStorageListStatement() {
        return "SELECT x, z\nFROM bluemap_grid_storage_data\nWHERE map = ?\nAND storage = ?\nAND compression = ?\nLIMIT ? OFFSET ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String gridStorageCountMapItemsStatement() {
        return "SELECT COUNT(*)\nFROM bluemap_grid_storage_data\nWHERE map = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String gridStoragePurgeMapStatement() {
        return "DELETE\nFROM bluemap_grid_storage_data\nWHERE CTID IN (\n SELECT CTID\n FROM bluemap_grid_storage_data t\n WHERE t.map = ?\n LIMIT ?\n)\n";
    }

    @Override
    @Language(value="postgresql")
    public String purgeMapStatement() {
        return "DELETE\nFROM bluemap_map\nWHERE id = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String hasMapStatement() {
        return "SELECT COUNT(*) > 0\nFROM bluemap_map m\nWHERE m.map_id = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String listMapIdsStatement() {
        return "SELECT map_id\nFROM bluemap_map m\nLIMIT ? OFFSET ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String findMapKeyStatement() {
        return "SELECT id\nFROM bluemap_map\nWHERE map_id = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String createMapKeyStatement() {
        return "INSERT\nINTO bluemap_map (map_id)\nVALUES (?)\n";
    }

    @Override
    @Language(value="postgresql")
    public String findCompressionKeyStatement() {
        return "SELECT id\nFROM bluemap_compression\nWHERE key = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String createCompressionKeyStatement() {
        return "INSERT\nINTO bluemap_compression (key)\nVALUES (?)\n";
    }

    @Override
    @Language(value="postgresql")
    public String findItemStorageKeyStatement() {
        return "SELECT id\nFROM bluemap_item_storage\nWHERE key = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String createItemStorageKeyStatement() {
        return "INSERT\nINTO bluemap_item_storage (key)\nVALUES (?)\n";
    }

    @Override
    @Language(value="postgresql")
    public String findGridStorageKeyStatement() {
        return "SELECT id\nFROM bluemap_grid_storage\nWHERE key = ?\n";
    }

    @Override
    @Language(value="postgresql")
    public String createGridStorageKeyStatement() {
        return "INSERT\nINTO bluemap_grid_storage (key)\nVALUES (?)\n";
    }
}

